/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.field;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.optimizations.common.ConcurrentLiteralValueTracker;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Marker is used to represent a known value of a final field")
@ValidOn(value={JField.class})
public class FieldSingleValueMarker
implements Marker {
    @Nonnull
    private final ConcurrentLiteralValueTracker tracker = new ConcurrentLiteralValueTracker();

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError();
    }

    boolean isMultipleOrNonLiteralValue() {
        return this.tracker.isMultipleOrNonLiteralValue();
    }

    @CheckForNull
    JValueLiteral getConsolidatedValue() {
        return this.tracker.getConsolidatedValue();
    }

    @CheckForNull
    private static FieldSingleValueMarker create(@Nonnull JField field) {
        JDefinedClassOrInterface type = field.getEnclosingType();
        assert (type.isToEmit());
        FieldSingleValueMarker marker = new FieldSingleValueMarker();
        if (field.isStatic()) {
            boolean hasStaticInit = false;
            for (JMethod method : type.getMethods()) {
                if (!JMethod.isClinit(method)) continue;
                hasStaticInit = true;
                break;
            }
            if (!hasStaticInit) {
                marker.tracker.markExpression(field.getType().createDefaultValue(field.getSourceInfo()));
            }
        }
        return marker;
    }

    @CheckForNull
    public static FieldSingleValueMarker getOrCreate(@Nonnull JField field) {
        if (field.isVolatile()) {
            return null;
        }
        FieldSingleValueMarker marker = field.getMarker(FieldSingleValueMarker.class);
        if (marker != null) {
            return marker;
        }
        marker = FieldSingleValueMarker.create(field);
        if (marker == null) {
            return null;
        }
        FieldSingleValueMarker existing = field.addMarkerIfAbsent(marker);
        return existing != null ? existing : marker;
    }

    public static void markValue(@Nonnull JField field, @Nonnull JExpression expression) {
        FieldSingleValueMarker marker = FieldSingleValueMarker.getOrCreate(field);
        if (marker != null) {
            marker.tracker.markExpression(expression);
        }
    }

    public static void markValues(@Nonnull JField field, @Nonnull Collection<JExpression> expressions) {
        FieldSingleValueMarker marker = FieldSingleValueMarker.getOrCreate(field);
        if (marker != null) {
            for (JExpression expression : expressions) {
                marker.tracker.markExpression(expression);
            }
        }
    }
}

