/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.inlining;

import com.android.jack.google.common.collect.Lists;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.CloneStatementVisitor;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Transform(add={JReturnStatement.class, JGoto.class, JAsgOperation.NonReusedAsg.class, JExpressionStatement.class, JLocalRef.class})
@Use(value={CloneStatementVisitor.class})
public final class InlineCloneStatementVisitor
extends CloneStatementVisitor {
    @Nonnull
    private final List<JCatchBlock> catchBlocks;
    @CheckForNull
    private final JLocal returnLocal;
    @Nonnull
    private final JLabeledStatement returnTarget;
    @CheckForNull
    private final JVariable targetInstanceVar;
    @Nonnull
    private final Deque<JBlock> curBlocks = Lists.newLinkedList();
    @Nonnull
    private final Map<JParameter, JLocal> parameterMap;

    public InlineCloneStatementVisitor(@Nonnull TransformationRequest trRequest, @Nonnull JMethod enclosingMethod, @Nonnull List<JCatchBlock> catchBlocks, @CheckForNull JLocal returnLocal, @Nonnull JLabeledStatement returnTarget, @CheckForNull JVariable targetInstanceVar, @Nonnull Map<JParameter, JLocal> parameterMap) {
        super(trRequest, enclosingMethod);
        this.catchBlocks = catchBlocks;
        this.returnLocal = returnLocal;
        this.returnTarget = returnTarget;
        this.targetInstanceVar = targetInstanceVar;
        this.parameterMap = parameterMap;
    }

    @Nonnull
    public JBlock cloneMethodBody(@Nonnull JMethodBody body) {
        assert (!body.getMethod().getType().equals(JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()) || this.returnLocal == null);
        assert (body.getMethod().isStatic() || this.targetInstanceVar != null);
        return this.cloneStatement(body.getBlock());
    }

    @Override
    public boolean visit(@Nonnull JBlock orgBlock) {
        JBlock newBlock = new JBlock(orgBlock.getSourceInfo());
        this.curBlocks.push(newBlock);
        for (JStatement stmt : orgBlock.getStatements()) {
            JStatement newStmt = this.internalCloneStatement(stmt);
            newBlock.addStmt(newStmt);
        }
        this.curBlocks.poll();
        this.statement = this.updateCatchBlockList(newBlock, orgBlock);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JReturnStatement returnStmt) {
        SourceInfo info = returnStmt.getSourceInfo();
        JExpression expr = returnStmt.getExpr();
        if (expr != null) {
            JExpressionStatement newStmt = this.returnLocal == null ? new JExpressionStatement(info, this.cloneExpression(expr)) : new JExpressionStatement(info, new JAsgOperation(info, this.returnLocal.makeRef(info), this.cloneExpression(expr)));
            this.curBlocks.peek().addStmt(newStmt);
            this.updateCatchBlockList(newStmt, returnStmt);
        }
        this.statement = this.updateCatchBlockList(new JGoto(info, this.returnTarget), returnStmt);
        return false;
    }

    @Override
    @Nonnull
    protected JStatement updateCatchBlockList(@Nonnull JStatement clonedStmt, @Nonnull JStatement orignalStmt) {
        JStatement result = super.updateCatchBlockList(clonedStmt, orignalStmt);
        for (JCatchBlock catchBlock : this.catchBlocks) {
            result.appendCatchBlock(catchBlock);
        }
        return result;
    }

    @Override
    public boolean visit(@Nonnull JParameterRef ref) {
        this.expression = this.parameterMap.get(ref.getTarget()).makeRef(ref.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JThisRef ref) {
        assert (this.targetInstanceVar != null);
        this.expression = this.targetInstanceVar.makeRef(ref.getSourceInfo());
        return false;
    }

    @Override
    @Nonnull
    protected String cloneLocalName(@Nonnull String orgName) {
        return super.cloneLocalName(orgName) + "_cloned";
    }
}

