/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.inlining;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.library.FileType;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.optimizations.inlining.InlineMarker;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.location.Location;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Inline methods annotated with @ForceInline")
@Transform(add={InlineMarker.class})
@Constraint(no={DefinitionMarker.class, UseDefsMarker.class})
@Support(value={Optimizations.InlineAnnotatedMethods.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class InlineAnnotatedMethods
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @CheckForNull
    private final JDefinedAnnotationType forceInlineAnnotationType = InlineAnnotatedMethods.getJAnnotationType("com.android.jack.annotations.ForceInline");
    @Nonnull
    private final InlineVisitor inlineVisitor = new InlineVisitor();

    @CheckForNull
    private static JDefinedAnnotationType getJAnnotationType(@Nonnull String className) {
        String signature = NamingTools.getTypeSignatureName(className);
        JAnnotationType type = Jack.getSession().getPhantomLookup().getAnnotationType(signature);
        if (type instanceof JDefinedAnnotationType) {
            return (JDefinedAnnotationType)type;
        }
        return null;
    }

    @Override
    public void run(@Nonnull JMethod method) {
        if (this.forceInlineAnnotationType == null) {
            return;
        }
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        this.inlineVisitor.accept(method);
    }

    private class InlineVisitor
    extends JVisitor {
        private InlineVisitor() {
        }

        @Override
        public void endVisit(@Nonnull JMethodCall call) {
            InputLibrary inputLibrary;
            Collection<JMethod> targets = call.getMethodIdWide().getMethods();
            if (targets.size() != 1) {
                return;
            }
            JMethod target = targets.iterator().next();
            if (target.isAbstract() || target.isNative()) {
                return;
            }
            Location location = target.getEnclosingType().getLocation();
            if (location instanceof TypeInInputLibraryLocation && (inputLibrary = ((TypeInInputLibraryLocation)location).getInputLibrary()).containsFileType(FileType.PREBUILT)) {
                return;
            }
            assert (InlineAnnotatedMethods.this.forceInlineAnnotationType != null);
            Collection annotationList = target.getAnnotations(InlineAnnotatedMethods.this.forceInlineAnnotationType);
            if (!annotationList.isEmpty()) {
                call.addMarker(new InlineMarker(target));
            }
        }
    }
}

