/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;

@Description(value="Marker is used to represent a list of directly derived subclasses.")
@ValidOn(value={JDefinedClass.class})
public class DirectlyDerivedClassesMarker
implements Marker {
    @Nonnull
    private final ConcurrentLinkedQueue<JDefinedClass> directlyDerivedClasses = new ConcurrentLinkedQueue();

    private DirectlyDerivedClassesMarker() {
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    @Nonnull
    public static Collection<JDefinedClass> getDirectlyDerivedClasses(@Nonnull JDefinedClass clazz) {
        DirectlyDerivedClassesMarker marker = clazz.getMarker(DirectlyDerivedClassesMarker.class);
        return marker == null ? Collections.emptyList() : Jack.getUnmodifiableCollections().getUnmodifiableCollection(marker.directlyDerivedClasses);
    }

    public static boolean hasDirectlyDerivedClasses(@Nonnull JDefinedClass clazz) {
        DirectlyDerivedClassesMarker marker = clazz.getMarker(DirectlyDerivedClassesMarker.class);
        return marker != null && !marker.directlyDerivedClasses.isEmpty();
    }

    public static void markDirectlyDerivedClass(@Nonnull JDefinedClass clazz, @Nonnull JDefinedClass derived) {
        DirectlyDerivedClassesMarker existing;
        assert (clazz.isToEmit());
        DirectlyDerivedClassesMarker marker = clazz.getMarker(DirectlyDerivedClassesMarker.class);
        if (marker == null && (existing = clazz.addMarkerIfAbsent(marker = new DirectlyDerivedClassesMarker())) != null) {
            marker = existing;
        }
        marker.directlyDerivedClasses.add(derived);
    }
}

