/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JNumberValueLiteral;
import com.android.jack.ir.ast.JReinterpretCastOperation;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.optimizations.DefUsesAndUseDefsChainsSimplifier;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.CloneExpressionVisitor;
import com.android.jack.util.ControlFlowHelper;
import com.android.jack.util.DefsAndUsesChainOptimizationTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Simplify use definitions chains.")
@Constraint(need={UseDefsMarker.class, ThreeAddressCodeForm.class, ControlFlowGraph.class})
@Use(value={DefsAndUsesChainOptimizationTools.class})
@Support(value={Optimizations.UseDefSimplifier.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UseDefsChainsSimplifier
extends DefUsesAndUseDefsChainsSimplifier
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private static final StatisticId<Counter> SIMPLIFIED_USE_DEF_SYNTH = new StatisticId<Counter>("jack.optimization.usedef.synthetic", "Synthetic use def chain simplified", CounterImpl.class, Counter.class);
    @Nonnull
    private static final StatisticId<Counter> SIMPLIFIED_USE_DEF = new StatisticId<Counter>("jack.optimization.usedef.java", "Use def chain simplified", CounterImpl.class, Counter.class);
    @Nonnull
    private static final StatisticId<Counter> SIMPLIFIED_USE_DEF_WITH_CST = new StatisticId<Counter>("jack.optimization.usedef.constant", "Use def chain with constant simplified", CounterImpl.class, Counter.class);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    private final boolean optimizeCstDef = ThreadConfig.get(Optimizations.UseDefSimplifier.OPTIMIZE_CST_DEF);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        Visitor visitor = new Visitor();
        for (BasicBlock bb : cfg.getNodes()) {
            for (JStatement stmt : bb.getStatements()) {
                visitor.accept(stmt);
            }
        }
    }

    private class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JStatement s1) {
            List<JVariableRef> varsUsedBys1 = DefsAndUsesChainOptimizationTools.getUsedVariables(s1);
            for (JVariableRef varRefOfa : varsUsedBys1.toArray(new JVariableRef[varsUsedBys1.size()])) {
                DefinitionMarker defOfa;
                List<DefinitionMarker> defsOfa = DefsAndUsesChainOptimizationTools.getUsedDefinitions(varRefOfa);
                if (defsOfa.size() != 1 || !this.stmtCanBeOptimized(s1, defOfa = defsOfa.get(0))) continue;
                if (defOfa.getDefinedVariable().isSynthetic()) {
                    ((Counter)UseDefsChainsSimplifier.this.tracer.getStatistic(SIMPLIFIED_USE_DEF_SYNTH)).incValue();
                } else {
                    ((Counter)UseDefsChainsSimplifier.this.tracer.getStatistic(SIMPLIFIED_USE_DEF)).incValue();
                }
                JExpression exprValueOfa = defOfa.getValue();
                TransformationRequest tr = new TransformationRequest(s1);
                if (this.isLiteralWithoutSideEffect(exprValueOfa)) {
                    ((Counter)UseDefsChainsSimplifier.this.tracer.getStatistic(SIMPLIFIED_USE_DEF_WITH_CST)).incValue();
                    JExpression newExpr = new CloneExpressionVisitor().cloneExpression(exprValueOfa);
                    if (newExpr instanceof JNullLiteral) {
                        newExpr = new JReinterpretCastOperation(newExpr.getSourceInfo(), varRefOfa.getType(), newExpr);
                    }
                    tr.append(new Replace(varRefOfa, newExpr));
                } else {
                    JVariableRef varRefb = (JVariableRef)exprValueOfa;
                    JVariableRef newVarRefb = UseDefsChainsSimplifier.this.getNewVarRef(varRefb, varRefOfa.getSourceInfo());
                    UseDefsMarker udmOfNewVarRefb = new UseDefsMarker();
                    udmOfNewVarRefb.addUsedDefinitions(DefsAndUsesChainOptimizationTools.getUsedDefinitions(varRefb), newVarRefb);
                    newVarRefb.addMarker(udmOfNewVarRefb);
                    varsUsedBys1.add(newVarRefb);
                    tr.append(new Replace(varRefOfa, newVarRefb));
                }
                varsUsedBys1.remove(varRefOfa);
                defOfa.removeUse(varRefOfa);
                tr.commit();
            }
            return super.visit(s1);
        }

        private boolean isLiteralWithoutSideEffect(@Nonnull JExpression expr) {
            return expr instanceof JBooleanLiteral || expr instanceof JNullLiteral || expr instanceof JNumberValueLiteral;
        }

        private boolean stmtCanBeOptimized(@Nonnull JStatement s1, @Nonnull DefinitionMarker defOfa) {
            if (!defOfa.hasValue()) {
                return false;
            }
            if (defOfa.getValue() instanceof JVariableRef) {
                List<DefinitionMarker> defsOfbUseFroms0;
                JVariableRef varRefb = (JVariableRef)defOfa.getValue();
                BasicBlock bbOfs1 = ControlFlowHelper.getBasicBlock(s1);
                JStatement s0 = defOfa.getStatement();
                assert (s0 != null);
                BasicBlock bbOfs0 = ControlFlowHelper.getBasicBlock(s0);
                JVariable b = varRefb.getTarget();
                if (bbOfs0 == bbOfs1 ? !UseDefsChainsSimplifier.this.hasLocalDef(b, bbOfs0, s0, s1) : (defsOfbUseFroms0 = DefsAndUsesChainOptimizationTools.getUsedDefinitions(varRefb)).size() == 1 && this.bbHasOnlyDefinitions(bbOfs1, b, defsOfbUseFroms0) && !UseDefsChainsSimplifier.this.hasLocalDef(b, bbOfs1, null, s1)) {
                    return true;
                }
            } else if (UseDefsChainsSimplifier.this.optimizeCstDef && this.isLiteralWithoutSideEffect(defOfa.getValue())) {
                return true;
            }
            return false;
        }

        private boolean bbHasOnlyDefinitions(@Nonnull BasicBlock bb, @Nonnull JVariable var, @Nonnull List<DefinitionMarker> defsToFound) {
            int nbDef = 0;
            for (DefinitionMarker def : DefsAndUsesChainOptimizationTools.getReachingDefs(bb)) {
                if (def.getDefinedVariable() != var) continue;
                if (defsToFound.contains(def)) {
                    ++nbDef;
                    continue;
                }
                return false;
            }
            return defsToFound.size() == nbDef;
        }

        @Override
        public boolean visit(@Nonnull JLock x) {
            return false;
        }

        @Override
        public boolean visit(@Nonnull JUnlock x) {
            return false;
        }

        @Override
        public boolean visit(@Nonnull JIfStatement jIf) {
            super.visit(jIf);
            this.accept(jIf.getIfExpr());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            super.visit(switchStmt);
            this.accept(switchStmt.getExpr());
            return false;
        }
    }
}

