/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.RefAsStatement;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Remove useless variable copies.")
@Constraint(need={DefinitionMarker.class, UseDefsMarker.class, ThreeAddressCodeForm.class})
@Transform(add={RefAsStatement.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UnusedDefinitionRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final StatisticId<Counter> UNUSED_DEFINITION_REMOVED = new StatisticId<Counter>("jack.optimization.definition.removed", "Unused definition removed", CounterImpl.class, Counter.class);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    private final boolean removeUnusedNonSyntheticDefinition = ThreadConfig.get(Optimizations.REMOVE_UNUSED_NON_SYNTHETIC_DEFINITION);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr);
        visitor.accept(method);
        tr.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        public Visitor(TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binary) {
            DefinitionMarker dm;
            JExpression rhs = binary.getRhs();
            if (binary instanceof JAsgOperation && !(rhs instanceof JExceptionRuntimeValue) && !rhs.canThrow() && !(rhs instanceof JNullLiteral) && (dm = binary.getMarker(DefinitionMarker.class)) != null && dm.isUnused() && (UnusedDefinitionRemover.this.removeUnusedNonSyntheticDefinition || dm.getDefinedVariable().isSynthetic())) {
                assert (!(binary.getLhs() instanceof JFieldRef) && !(binary.getLhs() instanceof JArrayRef));
                this.removeUnusedDefinition((JAsgOperation)binary);
            }
            return super.visit(binary);
        }

        private void removeUnusedDefinition(@Nonnull JAsgOperation binary) {
            assert (!(binary.getRhs() instanceof JExceptionRuntimeValue));
            UnusedDefinitionRemover.this.tracer.getStatistic(UNUSED_DEFINITION_REMOVED).incValue();
            JNode binaryParent = binary.getParent();
            assert (binaryParent != null);
            this.tr.append(new Remove(binaryParent));
            if (binary.getRhs() instanceof JVariableRef) {
                UseDefsMarker udm = ((JVariableRef)binary.getRhs()).getMarker(UseDefsMarker.class);
                assert (udm != null);
                List<DefinitionMarker> previouslyUsedDef = udm.getDefs();
                udm.removeAllUsedDefinitions((JVariableRef)binary.getRhs());
                for (DefinitionMarker dmUsed : previouslyUsedDef) {
                    JExpression expr;
                    JNode definition = dmUsed.getDefinition();
                    if (!dmUsed.isUnused() || !dmUsed.hasValue() || (expr = dmUsed.getValue()) instanceof JExceptionRuntimeValue || expr.canThrow()) continue;
                    this.removeUnusedDefinition((JAsgOperation)definition);
                }
            }
        }
    }
}

