/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNumberLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.Number;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.ImplicitCast;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.CloneExpressionVisitor;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import javax.annotation.Nonnull;

@Description(value="Refines constant variables.")
@Constraint(need={UseDefsMarker.class, ControlFlowGraph.class}, no={ImplicitCast.class, JCastOperation.WithIntersectionType.class})
@Transform(add={JByteLiteral.class, JCharLiteral.class, JShortLiteral.class, JLongLiteral.class, JFloatLiteral.class, JDoubleLiteral.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class ConstantRefiner
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final StatisticId<Counter> REFINED_CONSTANT = new StatisticId<Counter>("jack.constant.refined", "Refined constant", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> CONSTANT_MOVE_TO_HIS_USAGE = new StatisticId<Counter>("jack.constant.moved", "Constant moved to his usage", CounterImpl.class, Counter.class);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        Visitor visitor = new Visitor(method);
        for (BasicBlock bb : cfg.getNodes()) {
            for (JStatement stmt : bb.getStatements()) {
                visitor.accept(stmt);
            }
        }
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod method;
        @Nonnull
        private final CloneExpressionVisitor cloneExpr = new CloneExpressionVisitor();

        public Visitor(JMethod method) {
            this.method = method;
        }

        @Override
        public boolean visit(@Nonnull JDynamicCastOperation cast) {
            boolean deepVisit = super.visit(cast);
            JExpression castedExpr = cast.getExpr();
            if (castedExpr instanceof JNumberLiteral && cast.getType() instanceof JPrimitiveType) {
                TransformationRequest tr = new TransformationRequest(this.method);
                if (cast.getType().isSameType(castedExpr.getType())) {
                    tr.append(new Replace(cast, castedExpr));
                } else {
                    SourceInfo si = cast.getSourceInfo();
                    Number numberValue = ((JNumberLiteral)((Object)castedExpr)).getNumber();
                    tr.append(new Replace(cast, this.refineCst(si, numberValue, ((JPrimitiveType)cast.getType()).getPrimitiveTypeEnum())));
                    ConstantRefiner.this.tracer.getStatistic(REFINED_CONSTANT).incValue();
                }
                tr.commit();
            }
            return deepVisit;
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binOp) {
            if (!binOp.getOp().isAssignment()) {
                this.moveConstantIfNeeded(binOp.getLhs());
                this.moveConstantIfNeeded(binOp.getRhs());
            } else if (binOp.getOp() == JBinaryOperator.ASG) {
                this.moveConstantIfNeeded(binOp.getRhs());
            }
            return super.visit(binOp);
        }

        private void moveConstantIfNeeded(@Nonnull JCastOperation expr) {
            this.moveConstantIfNeeded(expr.getExpr());
        }

        private void moveConstantIfNeeded(@Nonnull JVariableRef varRef) {
            DefinitionMarker dm;
            UseDefsMarker udm = varRef.getMarker(UseDefsMarker.class);
            assert (udm != null);
            if (udm.isUsingOnlyOneDefinition() && (dm = udm.getDefs().get(0)).hasValue() && dm.getValue() instanceof JValueLiteral && !dm.getValue().canThrow()) {
                TransformationRequest tr = new TransformationRequest(this.method);
                if (varRef.getParent() instanceof JCastOperation) {
                    JCastOperation cast = (JCastOperation)varRef.getParent();
                    assert (cast != null);
                    if (cast.getType().isSameType(dm.getValue().getType())) {
                        tr.append(new Replace(cast, this.cloneExpr.cloneExpression(dm.getValue())));
                    } else if (dm.getValue() instanceof JNumberLiteral && cast.getType() instanceof JPrimitiveType) {
                        SourceInfo si = cast.getSourceInfo();
                        Number numberValue = ((JNumberLiteral)((Object)dm.getValue())).getNumber();
                        tr.append(new Replace(cast, this.refineCst(si, numberValue, ((JPrimitiveType)cast.getType()).getPrimitiveTypeEnum())));
                        ConstantRefiner.this.tracer.getStatistic(REFINED_CONSTANT).incValue();
                    } else {
                        tr.append(new Replace(varRef, this.cloneExpr.cloneExpression(dm.getValue())));
                    }
                } else {
                    tr.append(new Replace(varRef, this.cloneExpr.cloneExpression(dm.getValue())));
                }
                udm.removeAllUsedDefinitions(varRef);
                ConstantRefiner.this.tracer.getStatistic(CONSTANT_MOVE_TO_HIS_USAGE).incValue();
                tr.commit();
            }
        }

        private void moveConstantIfNeeded(@Nonnull JExpression expr) {
            if (expr instanceof JVariableRef) {
                this.moveConstantIfNeeded((JVariableRef)expr);
            } else if (expr instanceof JCastOperation) {
                this.moveConstantIfNeeded((JCastOperation)expr);
            }
        }

        @Nonnull
        private JValueLiteral refineCst(@Nonnull SourceInfo si, @Nonnull Number numberValue, @Nonnull JPrimitiveType.JPrimitiveTypeEnum destType) {
            switch (destType) {
                case BOOLEAN: {
                    assert (numberValue.byteValue() == 1 || numberValue.byteValue() == 0);
                    return new JBooleanLiteral(si, numberValue.byteValue() == 1);
                }
                case BYTE: {
                    return new JByteLiteral(si, numberValue.byteValue());
                }
                case SHORT: {
                    return new JShortLiteral(si, numberValue.shortValue());
                }
                case CHAR: {
                    return new JCharLiteral(si, numberValue.charValue());
                }
                case INT: {
                    return new JIntLiteral(si, numberValue.intValue());
                }
                case FLOAT: {
                    return new JFloatLiteral(si, numberValue.floatValue());
                }
                case DOUBLE: {
                    return new JDoubleLiteral(si, numberValue.doubleValue());
                }
                case LONG: {
                    return new JLongLiteral(si, numberValue.longValue());
                }
            }
            throw new AssertionError((Object)"Type not supported to refine a constant");
        }

        @Override
        public boolean visit(@Nonnull JIfStatement jIf) {
            this.visit((JStatement)jIf);
            this.accept(jIf.getIfExpr());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            this.accept(switchStmt.getExpr());
            return false;
        }
    }
}

