/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.meta;

import com.android.jack.meta.Meta;
import com.android.jack.resource.ResourceOrMeta;
import com.android.jack.resource.ResourceOrMetaImporter;
import com.android.jack.resource.ResourceReadingException;
import com.android.jack.resource.StandaloneResOrMetaLocation;
import com.android.sched.util.codec.DirectoryInputVFSCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.id.ListPropertyId;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VPath;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@HasKeyId
public class MetaImporter
extends ResourceOrMetaImporter {
    @Nonnull
    public static final ListPropertyId<InputVFS> IMPORTED_META = new ListPropertyId<InputVFS>("jack.import.meta", "Meta to import", new DirectoryInputVFSCodec().withoutCache().setInfoString("imported-meta")).minElements(0).addDefaultValue(Collections.emptyList());

    public MetaImporter(@Nonnull List<InputVFS> metaDirs) {
        super(metaDirs);
    }

    @Nonnull
    public List<Meta> getImports() {
        try {
            return super.getImports();
        }
        catch (ResourceReadingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected void addImportedResource(@Nonnull InputVFile file, @Nonnull String currentPath, @Nonnull Location resourceDirLocation, @Nonnull List<ResourceOrMeta> resultList) {
        VPath path = new VPath(currentPath, '/');
        Meta newMeta = new Meta(path, file, new StandaloneMetaLocation(resourceDirLocation, path));
        resultList.add(newMeta);
    }

    private static class StandaloneMetaLocation
    extends StandaloneResOrMetaLocation {
        public StandaloneMetaLocation(@Nonnull Location baseLocation, @Nonnull VPath path) {
            super(baseLocation, path);
        }

        @Override
        @Nonnull
        public String getDescription() {
            return this.baseLocation.getDescription() + ", meta '" + this.path.getPathAsString('/') + '\'';
        }
    }
}

