/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library.v0003;

import com.android.jack.google.common.collect.ImmutableSet;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.JackLibrary;
import com.android.jack.library.JackLibraryFactory;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryLocation;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.library.v0003.InputJackLibraryImpl;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.vfs.BadVFSFormatException;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.DeflateFS;
import com.android.sched.vfs.GenericInputOutputVFS;
import com.android.sched.vfs.GenericInputVFS;
import com.android.sched.vfs.GenericOutputVFS;
import com.android.sched.vfs.InputOutputVFS;
import com.android.sched.vfs.InputOutputVFile;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.MessageDigestFS;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.PrefixedFS;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WrongVFSTypeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class OutputJackLibraryImpl
extends OutputJackLibrary {
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();
    private boolean closed = false;
    private final boolean generateJacklibDigest = ThreadConfig.get(JackLibraryFactory.GENERATE_JACKLIB_DIGEST);
    @Nonnegative
    private int numLinkedLibraries = 1;
    @Nonnull
    private final Map<FileType, InputOutputVFS> sectionVFS = new EnumMap<FileType, InputOutputVFS>(FileType.class);
    @Nonnull
    private final LibraryLocation location = new LibraryLocation(this.vfs.getLocation());

    public OutputJackLibraryImpl(@Nonnull VFS vfs, @Nonnull String emitterId, @Nonnull String emitterVersion) {
        super(new Properties(), vfs);
        this.locationList.add(this.location);
        try {
            this.loadLibraryProperties(new GenericInputVFS(vfs));
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        this.putProperty("lib.emitter", emitterId);
        this.putProperty("lib.emitter.version", emitterVersion);
        this.putProperty("lib.version.major", String.valueOf(this.getMajorVersion()));
        this.putProperty("lib.version.minor", String.valueOf(this.getMinorVersion()));
    }

    synchronized void incrementNumLinkedLibraries() {
        ++this.numLinkedLibraries;
    }

    @Override
    @Nonnull
    public OutputVFile createFile(@Nonnull FileType fileType, @Nonnull VPath typePath) throws CannotCreateFileException {
        assert (!this.isClosed());
        this.addFileType(fileType);
        return this.getSectionVFS(fileType).getRootDir().createOutputVFile(this.buildFileVPath(fileType, typePath));
    }

    @Override
    public boolean needsSequentialWriting() {
        return this.vfs.needsSequentialWriting();
    }

    @Override
    @Nonnull
    public LibraryLocation getLocation() {
        return this.location;
    }

    @Nonnull
    private synchronized InputOutputVFS getSectionVFS(@Nonnull FileType fileType) throws CannotCreateFileException {
        InputOutputVFS currentSectionVFS;
        if (this.sectionVFS.containsKey((Object)fileType)) {
            currentSectionVFS = this.sectionVFS.get((Object)fileType);
        } else {
            BaseVFS outputVFS;
            block9: {
                VPath prefixPath = InputJackLibraryImpl.getSectionPath(fileType);
                outputVFS = null;
                try {
                    outputVFS = new PrefixedFS(this.vfs, prefixPath, FileOrDirectory.Existence.MAY_EXIST);
                    if (!this.generateJacklibDigest || fileType != FileType.PREBUILT) break block9;
                    try {
                        outputVFS = new MessageDigestFS(outputVFS, ThreadConfig.get(JackLibraryFactory.MESSAGE_DIGEST_ALGO));
                    }
                    catch (WrongVFSTypeException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                catch (WrongVFSTypeException e) {
                    throw new AssertionError((Object)e);
                }
                catch (BadVFSFormatException e) {
                    throw new AssertionError((Object)e);
                }
                catch (NotDirectoryException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (fileType != FileType.LOG) {
                outputVFS = new DeflateFS(outputVFS);
            }
            currentSectionVFS = new GenericInputOutputVFS(outputVFS);
            this.sectionVFS.put(fileType, currentSectionVFS);
        }
        return currentSectionVFS;
    }

    @Override
    public synchronized void close() throws LibraryIOException {
        if (!this.closed) {
            this.notifyToClose();
            this.closed = true;
        }
    }

    synchronized void notifyToClose() throws LibraryIOException {
        --this.numLinkedLibraries;
        if (this.numLinkedLibraries == 0) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws LibraryIOException {
        GenericOutputVFS goVFS = null;
        Config config = ThreadConfig.getConfig();
        Collection<PropertyId<?>> properties = config.getPropertyIds();
        for (PropertyId<?> property : properties) {
            if (!property.hasCategory(DumpInLibrary.class)) continue;
            this.libraryProperties.put("config." + property.getName(), config.getAsString(property));
        }
        for (FileType fileType : this.fileTypes) {
            this.libraryProperties.put(this.buildPropertyName(fileType, null), String.valueOf(true));
        }
        try {
            goVFS = new GenericOutputVFS(this.vfs);
            OutputVFile libraryPropertiesOut = goVFS.getRootDir().createOutputVFile(LIBRARY_PROPERTIES_VPATH);
            try (OutputStream propertiesOS = null;){
                propertiesOS = libraryPropertiesOut.getOutputStream();
                this.libraryProperties.store(propertiesOS, "Library properties");
            }
            try {
                for (InputOutputVFS intputOutputVFS : this.sectionVFS.values()) {
                    intputOutputVFS.close();
                }
            }
            catch (CannotCloseException e) {
                throw new LibraryIOException(this.getLocation(), e);
            }
        }
        catch (CannotCreateFileException | WrongPermissionException | IOException e) {
            throw new LibraryIOException(this.getLocation(), e);
        }
        finally {
            try {
                if (goVFS != null) {
                    goVFS.close();
                }
            }
            catch (CannotCloseException e) {
                throw new LibraryIOException(this.getLocation(), e);
            }
        }
    }

    @Override
    public int getMinorVersion() {
        return 5;
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    @Nonnull
    public Iterator<InputVFile> iterator(@Nonnull FileType fileType) {
        if (!this.containsFileType(fileType)) {
            return ImmutableSet.of().iterator();
        }
        ArrayList<InputVFile> inputVFiles = new ArrayList<InputVFile>();
        try {
            this.fillFiles(this.getSectionVFS(fileType).getRootDir(), inputVFiles);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        return inputVFiles.listIterator();
    }

    @Override
    @Nonnull
    public InputOutputVFile getFile(@Nonnull FileType fileType, @Nonnull VPath typePath) throws FileTypeDoesNotExistException {
        try {
            return this.getSectionVFS(fileType).getRootDir().getInputVFile(this.buildFileVPath(fileType, typePath));
        }
        catch (CannotCreateFileException | NoSuchFileException | NotFileOrDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public void delete(@Nonnull FileType fileType, @Nonnull VPath typePath) throws CannotDeleteFileException, FileTypeDoesNotExistException {
        assert (!this.isClosed());
        try {
            this.getSectionVFS(fileType).getRootDir().getInputVFile(this.buildFileVPath(fileType, typePath)).delete();
        }
        catch (CannotCreateFileException | NoSuchFileException | NotFileOrDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Nonnull
    public VPath buildFileVPath(@Nonnull FileType fileType, @Nonnull VPath vpath) {
        VPath clonedPath = vpath.clone();
        clonedPath.addSuffix(InputJackLibraryImpl.getExtension(fileType));
        return clonedPath;
    }

    @Override
    @Nonnull
    protected String getPropertyPrefix(@Nonnull FileType type) {
        return InputJackLibraryImpl.getPropertyPrefixImpl(type);
    }

    private synchronized boolean isClosed() {
        return this.closed;
    }

    @Nonnull
    private void loadLibraryProperties(@Nonnull InputVFS vfs) throws NoSuchFileException {
        InputVFile libProp;
        try {
            libProp = vfs.getRootDir().getInputVFile(JackLibrary.LIBRARY_PROPERTIES_VPATH);
        }
        catch (NotFileOrDirectoryException e) {
            throw new AssertionError((Object)e);
        }
        InputStream is = null;
        try {
            is = libProp.getInputStream();
            this.libraryProperties.load(is);
        }
        catch (WrongPermissionException | IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close input stream on " + libProp.getLocation().getDescription(), e);
                }
            }
        }
    }
}

