/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library.v0001;

import com.android.jack.google.common.collect.ImmutableSet;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.JackLibraryFactory;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryVersionException;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.vfs.BadVFSFormatException;
import com.android.sched.vfs.GenericInputVFS;
import com.android.sched.vfs.InputVDir;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.MessageDigestFS;
import com.android.sched.vfs.PrefixedFS;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WrongVFSTypeException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class InputJackLibraryImpl
extends InputJackLibrary {
    @Nonnull
    private static final VPath RSC_PREFIX = new VPath("rsc", '/');
    @Nonnull
    private static final VPath DEPENDENCY_PREFIX = new VPath("dependencies", '/');
    @Nonnull
    private static final VPath LOG_PREFIX = new VPath("logs", '/');
    @Nonnull
    private static final VPath JPP_PREFIX = new VPath("jpp", '/');
    @Nonnull
    private static final VPath JAYCE_PREFIX = new VPath("jayce", '/');
    @Nonnull
    private static final VPath DEX_PREFIX = new VPath("dex", '/');
    @Nonnull
    private final Map<FileType, InputVFS> sectionVFS = new EnumMap<FileType, InputVFS>(FileType.class);

    public InputJackLibraryImpl(@Nonnull VFS vfs, @Nonnull Properties libraryProperties) throws LibraryVersionException, LibraryFormatException {
        super(libraryProperties, vfs);
        this.vfs = vfs;
        this.check();
        this.fillFileTypes();
    }

    @Override
    @Nonnull
    public InputVFile getFile(@Nonnull FileType fileType, @Nonnull VPath typePath) throws FileTypeDoesNotExistException {
        if (!this.containsFileType(fileType)) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        try {
            InputVFS currentSectionVFS = this.getSectionVFS(fileType);
            return currentSectionVFS.getRootDir().getInputVFile(this.buildFileVPath(fileType, typePath));
        }
        catch (NotFileOrDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        catch (NoSuchFileException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public InputVDir getDir(@Nonnull FileType fileType, @Nonnull VPath typePath) throws FileTypeDoesNotExistException {
        try {
            InputVFS currentSectionVFS = this.getSectionVFS(fileType);
            return currentSectionVFS.getRootDir().getInputVDir(typePath);
        }
        catch (NotDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        catch (NoSuchFileException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public Iterator<InputVFile> iterator(@Nonnull FileType fileType) {
        if (!this.containsFileType(fileType)) {
            return ImmutableSet.of().iterator();
        }
        ArrayList<InputVFile> inputVFiles = new ArrayList<InputVFile>();
        this.fillFiles(this.getSectionVFS(fileType).getRootDir(), inputVFiles);
        return inputVFiles.listIterator();
    }

    @Nonnull
    private synchronized InputVFS getSectionVFS(@Nonnull FileType fileType) {
        InputVFS currentSectionVFS;
        if (this.sectionVFS.containsKey((Object)fileType)) {
            currentSectionVFS = this.sectionVFS.get((Object)fileType);
        } else {
            PrefixedFS prefixedInputVFS = null;
            try {
                prefixedInputVFS = new PrefixedFS(this.vfs, InputJackLibraryImpl.getSectionPath(fileType), FileOrDirectory.Existence.MUST_EXIST);
            }
            catch (WrongVFSTypeException e) {
                throw new AssertionError((Object)e);
            }
            catch (CannotCreateFileException e) {
                throw new AssertionError((Object)e);
            }
            catch (NotDirectoryException e) {
                throw new AssertionError((Object)e);
            }
            if (fileType == FileType.PREBUILT) {
                try {
                    currentSectionVFS = new GenericInputVFS(new MessageDigestFS(prefixedInputVFS, ThreadConfig.get(JackLibraryFactory.MESSAGE_DIGEST_ALGO)));
                }
                catch (BadVFSFormatException | WrongVFSTypeException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                currentSectionVFS = new GenericInputVFS(prefixedInputVFS);
            }
            this.sectionVFS.put(fileType, currentSectionVFS);
        }
        return currentSectionVFS;
    }

    @Override
    public synchronized void close() throws LibraryIOException {
        try {
            for (InputVFS currentSectionVFS : this.sectionVFS.values()) {
                currentSectionVFS.close();
            }
            this.vfs.close();
        }
        catch (CannotCloseException e) {
            throw new LibraryIOException(this.getLocation(), e);
        }
    }

    @Override
    public boolean isClosed() {
        boolean baseVFSClosed = this.vfs.isClosed();
        if (baseVFSClosed) {
            for (InputVFS currentSectionVFS : this.sectionVFS.values()) {
                assert (currentSectionVFS.isClosed());
            }
        }
        return baseVFSClosed;
    }

    @Override
    @Nonnegative
    public int getMajorVersion() {
        return 1;
    }

    @Override
    @Nonnegative
    public int getSupportedMinorMin() {
        return 1;
    }

    @Override
    @Nonnegative
    public int getSupportedMinor() {
        return 1;
    }

    @Override
    @Nonnull
    public void delete(@Nonnull FileType fileType, @Nonnull VPath typePath) throws CannotDeleteFileException, FileTypeDoesNotExistException {
        try {
            InputVFS currentSectionVFS = this.getSectionVFS(fileType);
            currentSectionVFS.getRootDir().getInputVFile(this.buildFileVPath(fileType, typePath)).delete();
        }
        catch (NotFileOrDirectoryException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
        catch (NoSuchFileException e) {
            throw new FileTypeDoesNotExistException(this.getLocation(), typePath, fileType);
        }
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Nonnull
    public VPath buildFileVPath(@Nonnull FileType fileType, @Nonnull VPath vpath) {
        VPath clonedPath = vpath.clone();
        clonedPath.addSuffix(InputJackLibraryImpl.getExtension(fileType));
        return clonedPath;
    }

    @Override
    @CheckForNull
    public String getDigest() {
        if (!this.containsFileType(FileType.PREBUILT)) {
            return null;
        }
        return this.getSectionVFS(FileType.PREBUILT).getDigest();
    }

    @Override
    @Nonnull
    protected String getPropertyPrefix(@Nonnull FileType type) {
        switch (type) {
            case PREBUILT: {
                return "dex";
            }
            case JAYCE: {
                return "jayce";
            }
            case META: {
                return "jpp";
            }
            case LOG: {
                return "logs";
            }
            case DEPENDENCIES: {
                return "dependencies";
            }
            case RSC: {
                return "rsc";
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    private static String getExtension(@Nonnull FileType type) {
        switch (type) {
            case PREBUILT: {
                return ".dex";
            }
            case JAYCE: {
                return ".jayce";
            }
            case LOG: {
                return ".log";
            }
            case DEPENDENCIES: {
                return ".dep";
            }
        }
        return "";
    }

    @Nonnull
    private static VPath getSectionPath(@Nonnull FileType type) {
        switch (type) {
            case PREBUILT: {
                return DEX_PREFIX;
            }
            case JAYCE: {
                return JAYCE_PREFIX;
            }
            case META: {
                return JPP_PREFIX;
            }
            case LOG: {
                return LOG_PREFIX;
            }
            case DEPENDENCIES: {
                return DEPENDENCY_PREFIX;
            }
            case RSC: {
                return RSC_PREFIX;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean hasCompliantPrebuilts() {
        return true;
    }
}

