/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.library.InputLibrary;
import com.android.jack.library.InputLibraryCodec;
import com.android.sched.util.codec.ListCodec;
import com.android.sched.util.config.id.PropertyId;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;

public class LibraryPathPropertyId
extends PropertyId<List<InputLibrary>> {
    public LibraryPathPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull String infoString) {
        super(name, description, new ListCodec<InputLibrary>(new InputLibraryCodec().setInfoString(infoString)).setMin(0).setSeparator(File.pathSeparator));
        this.withAutoCheck();
    }

    @Nonnull
    private LibraryPathPropertyId withAutoCheck() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<List<InputLibrary>>(){

            @Override
            public void run(@Nonnull List<InputLibrary> inputLibList) {
                for (InputLibrary library : inputLibList) {
                    if (!library.isClosed()) {
                        throw new AssertionError((Object)("Library " + library.getLocation().getDescription() + " from property '" + LibraryPathPropertyId.this.getName() + "' is not closed"));
                    }
                }
            }
        });
        return this;
    }

    @Nonnull
    public LibraryPathPropertyId withoutAutoAction() {
        this.removeShutdownHook();
        return this;
    }

    @Nonnull
    public LibraryPathPropertyId addDefaultValue(@Nonnull List<InputLibrary> defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public ListCodec<InputLibrary> getCodec() {
        return (ListCodec)super.getCodec();
    }
}

