/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.marker.ThrownExceptionMarker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NMarker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class NThrownExceptionMarker
extends NMarker {
    @Nonnull
    public static final Token TOKEN = Token.THROWN_EXCEPTION;
    @Nonnull
    public List<String> thrownExceptions = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        ThrownExceptionMarker marker = (ThrownExceptionMarker)node;
        this.thrownExceptions = ImportHelper.getSignatureNameList(marker.getThrownExceptions());
    }

    @Override
    @Nonnull
    public ThrownExceptionMarker exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException {
        ArrayList<JClass> jThrownExceptions = new ArrayList<JClass>();
        for (String exceptionName : this.thrownExceptions) {
            jThrownExceptions.add(exportSession.getLookup().getClass(exceptionName));
        }
        return new ThrownExceptionMarker(jThrownExceptions);
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeIds(this.thrownExceptions);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.thrownExceptions = in.readIds();
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipIds();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

