/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NThisRef
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.THIS_REF;
    @CheckForNull
    public String type;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JThisRef jThisRef = (JThisRef)node;
        this.type = ImportHelper.getSignatureName(jThisRef.getType());
        this.sourceInfo = jThisRef.getSourceInfo();
    }

    @Override
    @Nonnull
    public JThisRef exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        assert (this.type != null);
        JThis jThis = exportSession.getCurrentMethod().getThis();
        assert (jThis != null);
        JThisRef jThisRef = jThis.makeRef(this.sourceInfo);
        return jThisRef;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.type);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.type = in.readId();
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

