/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.jayce.v0004.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NIfStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.IF_STATEMENT;
    @CheckForNull
    public NExpression ifExpression;
    @CheckForNull
    public NStatement thenStatement;
    @CheckForNull
    public NStatement elseStatement;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JIfStatement jIfStatement = (JIfStatement)node;
        this.ifExpression = (NExpression)loader.load(jIfStatement.getIfExpr());
        this.thenStatement = (NStatement)loader.load(jIfStatement.getThenStmt());
        this.elseStatement = (NStatement)loader.load(jIfStatement.getElseStmt());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jIfStatement.getJCatchBlocks());
        this.sourceInfo = jIfStatement.getSourceInfo();
    }

    @Override
    @Nonnull
    public JIfStatement exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.ifExpression != null);
        assert (this.thenStatement != null);
        assert (this.sourceInfo != null);
        JStatement jElseStatement = null;
        if (this.elseStatement != null) {
            jElseStatement = this.elseStatement.exportAsJast(exportSession);
        }
        JIfStatement jIfStatement = new JIfStatement(this.sourceInfo, this.ifExpression.exportAsJast(exportSession), this.thenStatement.exportAsJast(exportSession), jElseStatement);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jIfStatement));
        }
        return jIfStatement;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNode(this.ifExpression);
        out.writeNode(this.thenStatement);
        out.writeNode(this.elseStatement);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.ifExpression = in.readNode(NExpression.class);
        this.thenStatement = in.readNode(NStatement.class);
        this.elseStatement = in.readNode(NStatement.class);
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipNode();
        in.skipNode();
        in.skipNode();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

