/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.jayce.v0004.nodes.NExpressionStatement;
import com.android.jack.jayce.v0004.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NForStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.FOR_STATEMENT;
    @CheckForNull
    public List<NStatement> initializers = Collections.emptyList();
    @CheckForNull
    public NExpression testExpression;
    @CheckForNull
    public List<NExpressionStatement> increments = Collections.emptyList();
    @CheckForNull
    public NStatement body;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JForStatement jForStatement = (JForStatement)node;
        this.initializers = loader.load(NStatement.class, jForStatement.getInitializers());
        this.testExpression = (NExpression)loader.load(jForStatement.getTestExpr());
        this.increments = loader.load(NExpressionStatement.class, jForStatement.getIncrements());
        this.body = (NStatement)loader.load(jForStatement.getBody());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jForStatement.getJCatchBlocks());
        this.sourceInfo = jForStatement.getSourceInfo();
    }

    @Override
    @Nonnull
    public JForStatement exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.initializers != null);
        assert (this.increments != null);
        JExpression jTestExpression = this.testExpression != null ? this.testExpression.exportAsJast(exportSession) : null;
        JStatement jBody = this.body != null ? this.body.exportAsJast(exportSession) : null;
        ArrayList<JStatement> jInitializers = new ArrayList<JStatement>(this.initializers.size());
        for (NStatement nStatement : this.initializers) {
            jInitializers.add(nStatement.exportAsJast(exportSession));
        }
        ArrayList<JExpressionStatement> jIncrements = new ArrayList<JExpressionStatement>(this.increments.size());
        for (NExpressionStatement increment : this.increments) {
            jIncrements.add(increment.exportAsJast(exportSession));
        }
        JForStatement jForStatement = new JForStatement(this.sourceInfo, jInitializers, jTestExpression, jIncrements, jBody);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jForStatement));
        }
        return jForStatement;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.initializers != null);
        assert (this.increments != null);
        out.writeNodes(this.initializers);
        out.writeNode(this.testExpression);
        out.writeNodes(this.increments);
        out.writeNode(this.body);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.initializers = in.readNodes(NStatement.class);
        this.testExpression = in.readNode(NExpression.class);
        this.increments = in.readNodes(NExpressionStatement.class);
        this.body = in.readNode(NStatement.class);
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipNodes();
        in.skipNode();
        in.skipNodes();
        in.skipNode();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

