/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NAnnotation;
import com.android.jack.jayce.v0004.nodes.NClassType;
import com.android.jack.jayce.v0004.nodes.NField;
import com.android.jack.jayce.v0004.nodes.NMarker;
import com.android.jack.jayce.v0004.nodes.NMethod;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.util.NamingTools;
import java.io.IOException;
import javax.annotation.Nonnull;

public class NEnumType
extends NClassType {
    @Nonnull
    public static final Token TOKEN = Token.ENUM;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JDefinedEnum jEnumType = (JDefinedEnum)node;
        this.modifiers = jEnumType.getModifier();
        this.signature = ImportHelper.getSignatureName(jEnumType);
        this.superClass = ImportHelper.getSignatureName(jEnumType.getSuperClass());
        this.superInterfaces = ImportHelper.getSignatureNameList(jEnumType.getImplements());
        this.enclosingType = ImportHelper.getSignatureName(jEnumType.getEnclosingType());
        this.enclosingMethodClass = ImportHelper.getMethodClassSignature(jEnumType.getEnclosingMethod());
        this.enclosingMethod = ImportHelper.getMethodSignature(jEnumType.getEnclosingMethod());
        this.inners = ImportHelper.getSignatureNameList(jEnumType.getMemberTypes());
        this.setFields(loader.load(NField.class, jEnumType.getFields()));
        this.setMethods(loader.load(NMethod.class, jEnumType.getMethods()));
        this.annotations = loader.load(NAnnotation.class, jEnumType.getAnnotations());
        this.markers = loader.load(NMarker.class, jEnumType.getAllMarkers());
        this.sourceInfo = jEnumType.getSourceInfo();
    }

    @Override
    @Nonnull
    public JDefinedEnum exportAsJast(@Nonnull ExportSession exportSession) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public JDefinedEnum create(@Nonnull JPackage enclosingPackage, @Nonnull JayceClassOrInterfaceLoader loader) {
        assert (this.signature != null);
        String binaryName = NamingTools.getClassBinaryNameFromDescriptor(this.signature);
        String simpleName = NamingTools.getSimpleClassNameFromBinaryName(binaryName);
        JDefinedEnum jEnumType = new JDefinedEnum(SourceInfo.UNKNOWN, simpleName, this.modifiers, enclosingPackage, loader);
        return jEnumType;
    }

    @Override
    public void loadStructure(@Nonnull JDefinedClassOrInterface loading, @Nonnull JayceClassOrInterfaceLoader loader) {
        assert (this.sourceInfo != null);
        assert (this.signature != null);
        JDefinedEnum jEnumType = (JDefinedEnum)loading;
        ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
        exportSession.setCurrentType(jEnumType);
        loading.setSourceInfo(this.sourceInfo);
        if (this.superClass != null) {
            jEnumType.setSuperClass(exportSession.getLookup().getClass(this.superClass));
        }
        for (String superInterface : this.superInterfaces) {
            jEnumType.addImplements(exportSession.getLookup().getInterface(superInterface));
        }
        if (this.enclosingType != null) {
            jEnumType.setEnclosingType((JClassOrInterface)exportSession.getLookup().getType(this.enclosingType));
        }
        if (this.enclosingMethodClass != null) {
            assert (this.enclosingMethod != null);
            JClass enclosingMethodJClass = exportSession.getLookup().getClass(this.enclosingMethodClass);
            if (enclosingMethodJClass instanceof JDefinedClass) {
                try {
                    jEnumType.setEnclosingMethod(exportSession.getDeclaredMethod((JDefinedClass)enclosingMethodJClass, this.enclosingMethod));
                }
                catch (JMethodLookupException superInterface) {
                    // empty catch block
                }
            }
        }
        for (String memberType : this.inners) {
            jEnumType.addMemberType((JClassOrInterface)exportSession.getLookup().getType(memberType));
        }
        for (NField field : this.getFields()) {
            JField jField = field.exportAsJast(exportSession, loader);
            jEnumType.addField(jField);
        }
        for (NMethod method : this.getMethods()) {
            JMethod jMethod = method.exportAsJast(exportSession, loader);
            jEnumType.addMethod(jMethod);
        }
        for (NMarker marker : this.markers) {
            jEnumType.addMarker(marker.exportAsJast(exportSession));
        }
        exportSession.getFieldInitializerFieldResolver().clear();
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeInt(this.modifiers);
        out.writeId(this.signature);
        out.writeId(this.superClass);
        out.writeIds(this.superInterfaces);
        out.writeId(this.enclosingType);
        out.writeId(this.enclosingMethodClass);
        out.writeId(this.enclosingMethod);
        out.writeIds(this.inners);
        out.writeNodes(this.getFields());
        out.writeNodes(this.getMethods());
        out.writeNodes(this.annotations);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.level = in.getNodeLevel();
        this.modifiers = in.readInt();
        this.signature = in.readId();
        if (this.level != NodeLevel.TYPES) {
            this.superClass = in.readId();
            this.superInterfaces = in.readIds();
            this.enclosingType = in.readId();
            this.enclosingMethodClass = in.readId();
            this.enclosingMethod = in.readId();
            this.inners = in.readIds();
            this.setFields(in.readNodes(NField.class));
            this.setMethods(in.readNodes(NMethod.class));
            this.annotations = in.readNodes(NAnnotation.class);
            this.markers = in.readNodes(NMarker.class);
        }
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        NodeLevel nodeLevel = in.getNodeLevel();
        in.skipInt();
        in.skipId();
        if (nodeLevel != NodeLevel.TYPES) {
            in.skipId();
            in.skipIds();
            in.skipId();
            in.skipId();
            in.skipId();
            in.skipIds();
            in.skipNodes();
            in.skipNodes();
            in.skipNodes();
            in.skipNodes();
        }
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

