/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NDynamicCastOperation
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.DYNAMIC_CAST_OPERATION;
    @CheckForNull
    public List<String> castTypes;
    @CheckForNull
    public NExpression expr;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JDynamicCastOperation jMultiCastOperation = (JDynamicCastOperation)node;
        this.castTypes = ImportHelper.getSignatureNameList(jMultiCastOperation.getTypes());
        this.expr = (NExpression)loader.load(jMultiCastOperation.getExpr());
        this.sourceInfo = jMultiCastOperation.getSourceInfo();
    }

    @Override
    @Nonnull
    public JDynamicCastOperation exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.castTypes != null);
        assert (this.expr != null);
        ArrayList<JType> jTypes = new ArrayList<JType>(this.castTypes.size());
        for (String types : this.castTypes) {
            jTypes.add(exportSession.getLookup().getType(types));
        }
        JExpression jExpr = this.expr.exportAsJast(exportSession);
        JDynamicCastOperation castOperation = new JDynamicCastOperation(this.sourceInfo, jExpr, jTypes);
        return castOperation;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.castTypes != null);
        out.writeIds(this.castTypes);
        out.writeNode(this.expr);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.castTypes = in.readIds();
        this.expr = in.readNode(NExpression.class);
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipIds();
        in.skipNode();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

