/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.io;

import com.android.jack.jayce.v0004.io.JayceInputStream;
import com.android.jack.jayce.v0004.io.ParseException;
import com.android.jack.jayce.v0004.io.Token;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

class Tokenizer {
    @Nonnull
    private final JayceInputStream in;
    @CheckForNull
    private Token currentTokenId;
    private boolean prefetched;
    @Nonnull
    private static final Token[] tokenMap = Token.values();

    public Tokenizer(@Nonnull InputStream in) {
        this.in = new JayceInputStream(in);
    }

    private void readNextToken() throws IOException {
        int token = this.in.readUnsignedByte();
        try {
            this.currentTokenId = tokenMap[token];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Unknown token: " + token);
        }
    }

    @Nonnull
    public Token next() throws IOException {
        if (this.prefetched) {
            this.prefetched = false;
        } else {
            this.readNextToken();
        }
        assert (this.currentTokenId != null);
        return this.currentTokenId;
    }

    public Token peekNext() throws IOException {
        if (!this.prefetched) {
            this.readNextToken();
            this.prefetched = true;
        }
        return this.currentTokenId;
    }

    public int readInt() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        return this.in.readInt();
    }

    public void skipInt() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        this.in.skipInt();
    }

    public byte readByte() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        return this.in.readByte();
    }

    public void skipByte() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        this.in.skipByte();
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public void skipBoolean() throws IOException {
        this.in.skipBoolean();
    }

    public long readLong() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        return this.in.readLong();
    }

    public void skipLong() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        this.in.skipLong();
    }

    public short readShort() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        return this.in.readShort();
    }

    public void skipShort() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        this.in.skipShort();
    }

    public char readChar() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        return this.in.readChar();
    }

    public void skipChar() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        this.in.skipChar();
    }

    public float readFloat() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        return Float.intBitsToFloat(this.readInt());
    }

    public void skipFloat() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        this.in.skipInt();
    }

    public double readDouble() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        return Double.longBitsToDouble(this.readLong());
    }

    public void skipDouble() throws IOException {
        this.currentTokenId = Token.NUMBER_VALUE;
        this.in.skipLong();
    }

    @CheckForNull
    public String readString() throws IOException {
        return this.in.readUTF();
    }

    public void skipString() throws IOException {
        this.in.skipUTF();
    }

    @CheckForNull
    public byte[] readBuffer() throws IOException {
        return this.in.readBuffer();
    }

    public void skipBuffer() throws IOException {
        this.in.skipBuffer();
    }

    private void readToken(@Nonnull Token expected) throws IOException {
        this.next();
        if (this.currentTokenId != expected) {
            throw new ParseException("Unexpected token " + String.valueOf((Object)this.currentTokenId) + " while token " + expected.toString() + " was expected");
        }
    }

    public void readOpen() {
    }

    public void readClose() throws IOException {
        this.readToken(Token.RPARENTHESIS);
    }

    public boolean readOpenFileName() throws IOException {
        if (this.peekNext() == Token.SHARP) {
            this.readToken(Token.SHARP);
            return true;
        }
        return false;
    }

    public void readCloseFileName() {
    }

    public boolean readOpenLineInfo() throws IOException {
        if (this.peekNext() == Token.LBRACKET) {
            this.readToken(Token.LBRACKET);
            return true;
        }
        return false;
    }

    public void readCloseLineInfo() {
    }

    public boolean readOpenCatchBlockIdAdd() throws IOException {
        if (this.peekNext() == Token.LCURLY_ADD) {
            this.readToken(Token.LCURLY_ADD);
            return true;
        }
        return false;
    }

    public boolean readOpenCatchBlockIdRemove() throws IOException {
        if (this.peekNext() == Token.LCURLY_REMOVE) {
            this.readToken(Token.LCURLY_REMOVE);
            return true;
        }
        return false;
    }

    public void readCloseCatchBlockId() {
    }
}

