/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.io;

import com.android.jack.JackEventType;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.JayceInternalWriter;
import com.android.jack.jayce.v0004.NNode;
import com.android.jack.jayce.v0004.NodeFactory;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceOutputStream;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.HasCatchBlockIds;
import com.android.jack.jayce.v0004.nodes.HasSourceInfo;
import com.android.jack.jayce.v0004.nodes.NMethod;
import com.android.jack.jayce.v0004.nodes.NMethodCall;
import com.android.jack.jayce.v0004.util.DispatchKindIdHelper;
import com.android.jack.jayce.v0004.util.FieldRefKindIdHelper;
import com.android.jack.jayce.v0004.util.MethodKindIdHelper;
import com.android.jack.jayce.v0004.util.ReceiverKindIdHelper;
import com.android.jack.jayce.v0004.util.RetentionPolicyIdHelper;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class JayceInternalWriterImpl
implements JayceInternalWriter {
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final JayceOutputStream out;
    @CheckForNull
    private String currentFileName;
    @Nonnegative
    private int currentLineNumber;
    @Nonnull
    private final List<String> currentCatchBlockList = new ArrayList<String>();
    @Nonnull
    private final HasLocation locationProvider;

    public JayceInternalWriterImpl(@Nonnull OutputStream out, @Nonnull HasLocation locationProvider) {
        this.out = new JayceOutputStream(out);
        this.locationProvider = locationProvider;
    }

    public void writeNode(@CheckForNull NNode node) throws IOException {
        if (node == null) {
            this.writeNull();
        } else {
            this.writeSourceInfoBegin(node);
            this.writeCatchBlockIds(node);
            this.writeToken(node.getToken());
            this.writeOpen();
            node.writeContent(this);
            this.writeSourceInfoEnd(node);
            assert (!(node instanceof NMethod) || this.currentCatchBlockList.isEmpty());
            this.writeClose();
        }
    }

    private void writeSourceInfoBegin(@Nonnull NNode node) throws IOException {
        if (node instanceof HasSourceInfo) {
            SourceInfo sourceInfo = ((HasSourceInfo)((Object)node)).getSourceInfos();
            if (sourceInfo == SourceInfo.UNKNOWN) {
                this.writeUnknowDebug();
            } else {
                this.writeFileNameIfDifferentFromCurrent(sourceInfo.getFileName());
                this.writeLineIfDifferentFromCurrent(sourceInfo.getStartLine());
            }
        }
    }

    private void writeSourceInfoEnd(@Nonnull NNode node) throws IOException {
        if (node instanceof HasSourceInfo) {
            SourceInfo sourceInfo = ((HasSourceInfo)((Object)node)).getSourceInfos();
            if (sourceInfo == SourceInfo.UNKNOWN) {
                this.writeUnknowDebug();
            } else {
                this.writeFileNameIfDifferentFromCurrent(sourceInfo.getFileName());
                this.writeLineIfDifferentFromCurrent(sourceInfo.getEndLine());
            }
        }
    }

    public void writeIds(@Nonnull List<String> list) throws IOException {
        this.writeOpen();
        this.writeTrimmedInt(list.size());
        for (String id : list) {
            this.writeId(id);
        }
        this.writeClose();
    }

    public void writeCatchBlockIds(@CheckForNull NNode node) throws IOException {
        if (node instanceof HasCatchBlockIds) {
            int i;
            List<String> list = ((HasCatchBlockIds)((Object)node)).getCatchBlockIds();
            ArrayList<String> removedIds = new ArrayList<String>(this.currentCatchBlockList.size());
            ArrayList<String> addedIds = new ArrayList<String>(list.size());
            for (String s : this.currentCatchBlockList) {
                removedIds.add(s);
            }
            for (String s : list) {
                addedIds.add(s);
            }
            this.currentCatchBlockList.retainAll(list);
            removedIds.removeAll(this.currentCatchBlockList);
            addedIds.removeAll(this.currentCatchBlockList);
            int addedIdsSize = addedIds.size();
            int removedIdsSize = removedIds.size();
            if (addedIdsSize > 0) {
                this.writeOpenAddCatchBlockIds();
                this.writeInt(addedIdsSize);
                for (i = 0; i < addedIdsSize; ++i) {
                    this.writeString((String)addedIds.get(i));
                }
                this.writeCloseCatchBlockIds();
            }
            if (removedIdsSize > 0) {
                this.writeOpenRemoveCatchBlockIds();
                this.writeInt(removedIdsSize);
                for (i = 0; i < removedIdsSize; ++i) {
                    this.writeString((String)removedIds.get(i));
                }
                this.writeCloseCatchBlockIds();
            }
            this.currentCatchBlockList.addAll(addedIds);
        }
    }

    public void writeNodes(@Nonnull Collection<? extends NNode> nodes) throws IOException {
        this.writeOpen();
        this.writeTrimmedInt(nodes.size());
        Iterator<? extends NNode> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            this.writeNode(iterator.next());
        }
        this.writeClose();
    }

    public void writeInt(int value) throws IOException {
        this.writeTrimmedInt(value);
        this.writeSpace();
    }

    private void writeTrimmedInt(int value) throws IOException {
        this.out.writeInt(value);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.out.writeBoolean(value);
    }

    public void writeLong(long value) throws IOException {
        this.writeTrimmedLong(value);
        this.writeSpace();
    }

    private void writeTrimmedLong(long value) throws IOException {
        this.out.writeLong(value);
    }

    public void writeByte(byte value) throws IOException {
        this.out.writeByte(value);
        this.writeSpace();
    }

    public void writeShort(short value) throws IOException {
        this.out.writeShort(value);
        this.writeSpace();
    }

    public void writeChar(char value) throws IOException {
        this.out.writeChar(value);
        this.writeSpace();
    }

    public void writeFloat(float value) throws IOException {
        this.writeTrimmedInt(Float.floatToRawIntBits(value));
        this.writeSpace();
    }

    public void writeDouble(double value) throws IOException {
        this.writeTrimmedLong(Double.doubleToRawLongBits(value));
        this.writeSpace();
    }

    public void writeId(@CheckForNull String id) throws IOException {
        this.writeString(id);
    }

    public void writeRetentionPolicyEnum(@Nonnull JRetentionPolicy enumValue) throws IOException {
        this.writeByte(RetentionPolicyIdHelper.getId(enumValue));
    }

    public void writeFieldRefKindEnum(@Nonnull FieldKind enumValue) throws IOException {
        this.writeByte(FieldRefKindIdHelper.getId(enumValue));
    }

    public void writeMethodKindEnum(@Nonnull MethodKind enumValue) throws IOException {
        this.writeByte(MethodKindIdHelper.getId(enumValue));
    }

    public void writeReceiverKindEnum(@Nonnull NMethodCall.ReceiverKind enumValue) throws IOException {
        this.writeByte(ReceiverKindIdHelper.getId(enumValue));
    }

    public void writeDispatchKindEnum(@Nonnull JMethodCall.DispatchKind enumValue) throws IOException {
        this.writeByte(DispatchKindIdHelper.getId(enumValue));
    }

    public void writeString(@CheckForNull String string) throws IOException {
        this.out.writeUTF(string);
    }

    public void writeBuffer(@CheckForNull byte[] b) throws IOException {
        this.out.writeBuffer(b);
    }

    public void writeFileNameIfDifferentFromCurrent(@Nonnull String fileName) throws IOException {
        if (!fileName.equals(this.currentFileName)) {
            this.writeCurrentFileName(fileName);
        }
    }

    private void writeUnknowDebug() throws IOException {
        if (this.currentFileName != null) {
            this.writeOpenFileName();
            this.writeString(null);
            this.writeCloseFileName();
            this.currentFileName = null;
            this.currentLineNumber = 0;
        }
    }

    private void writeCurrentFileName(@CheckForNull String fileName) throws IOException {
        this.writeOpenFileName();
        this.writeString(fileName);
        this.writeCloseFileName();
        this.currentFileName = fileName;
    }

    public void writeLineIfDifferentFromCurrent(@Nonnegative int lineNumber) throws IOException {
        if (lineNumber != this.currentLineNumber) {
            this.writeCurrentLine(lineNumber);
        }
    }

    public void writeCurrentLine(@Nonnegative int lineNumber) throws IOException {
        this.writeOpenLineInfo();
        this.writeTrimmedInt(lineNumber);
        this.writeCloseLineInfo();
        this.currentLineNumber = lineNumber;
    }

    private void writeNull() throws IOException {
        this.writeToken(Token.NULL);
        this.writeSpace();
    }

    private void writeSpace() throws IOException {
    }

    private void writeToken(@Nonnull Token token) throws IOException {
        this.out.writeByte(token.ordinal());
    }

    private void writeOpen() throws IOException {
    }

    private void writeClose() throws IOException {
        this.writeToken(Token.RPARENTHESIS);
    }

    private void writeOpenFileName() throws IOException {
        this.writeToken(Token.SHARP);
    }

    private void writeCloseFileName() throws IOException {
    }

    private void writeOpenLineInfo() throws IOException {
        this.writeToken(Token.LBRACKET);
    }

    private void writeCloseLineInfo() throws IOException {
    }

    private void writeOpenAddCatchBlockIds() throws IOException {
        this.writeToken(Token.LCURLY_ADD);
    }

    private void writeOpenRemoveCatchBlockIds() throws IOException {
        this.writeToken(Token.LCURLY_REMOVE);
    }

    private void writeCloseCatchBlockIds() throws IOException {
    }

    @Override
    public void write(@Nonnull JNode jNode) throws CannotWriteException {
        try (Event eventWriting = this.tracer.open(JackEventType.NNODE_WRITING);){
            NNode nNode;
            ImportHelper importHelper = new ImportHelper(new NodeFactory());
            try (Event eventConvert = this.tracer.open(JackEventType.JNODE_TO_NNODE_CONVERSION);){
                nNode = importHelper.load(jNode);
            }
            try {
                this.writeNode(nNode);
            }
            catch (IOException e) {
                throw new CannotWriteException(this.locationProvider, (Throwable)e);
            }
        }
    }

    @Override
    public int getCurrentMinor() {
        return 4;
    }

    @Override
    public void close() throws CannotCloseException {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new CannotCloseException(this.locationProvider, (Exception)e);
        }
    }
}

