/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.io;

import com.android.jack.Jack;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfoFactory;
import com.android.jack.jayce.DeclaredTypeNode;
import com.android.jack.jayce.JayceFormatException;
import com.android.jack.jayce.JayceInternalReader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0004.NNode;
import com.android.jack.jayce.v0004.io.InvalidTokenException;
import com.android.jack.jayce.v0004.io.ParseException;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.io.Tokenizer;
import com.android.jack.jayce.v0004.nodes.HasCatchBlockIds;
import com.android.jack.jayce.v0004.nodes.HasSourceInfo;
import com.android.jack.jayce.v0004.nodes.NDeclaredType;
import com.android.jack.jayce.v0004.nodes.NMethod;
import com.android.jack.jayce.v0004.nodes.NMethodCall;
import com.android.jack.jayce.v0004.util.DispatchKindIdHelper;
import com.android.jack.jayce.v0004.util.FieldRefKindIdHelper;
import com.android.jack.jayce.v0004.util.MethodKindIdHelper;
import com.android.jack.jayce.v0004.util.ReceiverKindIdHelper;
import com.android.jack.jayce.v0004.util.RetentionPolicyIdHelper;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.PercentImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class JayceInternalReaderImpl
implements JayceInternalReader {
    @Nonnull
    public static final StatisticId<Percent> SKIPPED_TYPE_STRUCTURE = new StatisticId<Percent>("jack.jayce-to-nnode.structure.skipped", "Type structure reading skipped by the reader", PercentImpl.class, Percent.class);
    @Nonnull
    public static final StatisticId<Percent> SKIPPED_BODY = new StatisticId<Percent>("jack.jayce-to-nnode.body.skipped", "Method body reading skipped by the reader", PercentImpl.class, Percent.class);
    @Nonnull
    private final Tokenizer tokenizer;
    @Nonnull
    private NodeLevel nodeLevel = NodeLevel.FULL;
    @CheckForNull
    private NDeclaredType type;
    @CheckForNull
    private String currentFileName;
    @Nonnegative
    private int currentLine;
    @Nonnull
    private final List<String> currentCatchBlockList = new ArrayList<String>();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final SourceInfoFactory sif = Jack.getSession().getSourceInfoFactory();

    public JayceInternalReaderImpl(@Nonnull InputStream in) {
        this.tokenizer = new Tokenizer(in);
    }

    @Nonnull
    public NodeLevel getNodeLevel() {
        return this.nodeLevel;
    }

    @CheckForNull
    public String readId() throws IOException {
        return this.readString();
    }

    public void skipId() throws IOException {
        this.skipString();
    }

    @CheckForNull
    public String readCurrentFileName() throws IOException {
        if (this.tokenizer.readOpenFileName()) {
            this.currentFileName = this.readString();
            if (this.currentFileName == null) {
                this.currentLine = 0;
            }
            this.tokenizer.readCloseFileName();
        }
        return this.currentFileName;
    }

    public void skipCurrentFileName() throws IOException {
        if (this.tokenizer.readOpenFileName()) {
            this.skipString();
            this.currentLine = 0;
            this.tokenizer.readCloseFileName();
        }
    }

    @Nonnegative
    public int readCurrentLine() throws IOException {
        if (this.tokenizer.readOpenLineInfo()) {
            this.currentLine = this.readInt();
            this.tokenizer.readCloseLineInfo();
        }
        return this.currentLine;
    }

    public void skipCurrentLine() throws IOException {
        if (this.tokenizer.readOpenLineInfo()) {
            this.skipInt();
            this.tokenizer.readCloseLineInfo();
        }
    }

    @Nonnull
    public JRetentionPolicy readRetentionPolicyEnum() throws IOException {
        return RetentionPolicyIdHelper.getValue(this.readByte());
    }

    public void skipRetentionPolicyEnum() throws IOException {
        this.skipByte();
    }

    @Nonnull
    public FieldKind readFieldRefKindEnum() throws IOException {
        return FieldRefKindIdHelper.getValue(this.readByte());
    }

    public void skipFieldRefKindEnum() throws IOException {
        this.skipByte();
    }

    @Nonnull
    public MethodKind readMethodKindEnum() throws IOException {
        return MethodKindIdHelper.getValue(this.readByte());
    }

    public void skipMethodKindEnum() throws IOException {
        this.skipByte();
    }

    @Nonnull
    public NMethodCall.ReceiverKind readReceiverKindEnum() throws IOException {
        return ReceiverKindIdHelper.getValue(this.readByte());
    }

    public void skipReceiverKindEnum() throws IOException {
        this.skipByte();
    }

    @Nonnull
    public JMethodCall.DispatchKind readDispatchKindEnum() throws IOException {
        return DispatchKindIdHelper.getValue(this.readByte());
    }

    public void skipDispatchKindEnum() throws IOException {
        this.skipByte();
    }

    @CheckForNull
    public String readString() throws IOException {
        return this.tokenizer.readString();
    }

    public void skipString() throws IOException {
        this.tokenizer.skipString();
    }

    @CheckForNull
    public byte[] readBuffer() throws IOException {
        return this.tokenizer.readBuffer();
    }

    public void skipBuffer() throws IOException {
        this.tokenizer.skipBuffer();
    }

    @Nonnull
    public List<String> readIds() throws IOException {
        this.tokenizer.readOpen();
        int length = this.readInt();
        ArrayList<String> ids = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            ids.add(this.readId());
        }
        this.tokenizer.readClose();
        return ids;
    }

    public void skipIds() throws IOException {
        this.tokenizer.readOpen();
        int length = this.readInt();
        for (int i = 0; i < length; ++i) {
            this.skipId();
        }
        this.tokenizer.readClose();
    }

    public void readCatchBlockIds() throws IOException {
        String id;
        int i;
        int length;
        if (this.tokenizer.readOpenCatchBlockIdAdd()) {
            length = this.tokenizer.readInt();
            for (i = 0; i < length; ++i) {
                id = this.readId();
                this.currentCatchBlockList.add(id);
                assert (this.currentCatchBlockList.indexOf(id) == this.currentCatchBlockList.lastIndexOf(id));
            }
            this.tokenizer.readCloseCatchBlockId();
        }
        if (this.tokenizer.readOpenCatchBlockIdRemove()) {
            length = this.tokenizer.readInt();
            for (i = 0; i < length; ++i) {
                id = this.readId();
                this.currentCatchBlockList.remove(id);
                assert (!this.currentCatchBlockList.contains(id));
            }
            this.tokenizer.readCloseCatchBlockId();
        }
    }

    public void skipCatchBlockIds() throws IOException {
        int i;
        int length;
        if (this.tokenizer.readOpenCatchBlockIdAdd()) {
            length = this.tokenizer.readInt();
            for (i = 0; i < length; ++i) {
                this.skipId();
            }
            this.tokenizer.readCloseCatchBlockId();
        }
        if (this.tokenizer.readOpenCatchBlockIdRemove()) {
            length = this.tokenizer.readInt();
            for (i = 0; i < length; ++i) {
                this.skipId();
            }
            this.tokenizer.readCloseCatchBlockId();
        }
    }

    public <T extends NNode> void skipNode() throws IOException, JayceFormatException {
        this.skipCurrentFileName();
        this.skipCurrentLine();
        this.skipCatchBlockIds();
        Token token = this.tokenizer.next();
        if (token == Token.NULL) {
            return;
        }
        this.tokenizer.readOpen();
        this.skipNodeInternal(token);
    }

    private <T extends NNode> void skipNodeInternal(@Nonnull Token token) throws IOException, JayceFormatException {
        try {
            token.skip(this);
            if (this.nodeLevel != NodeLevel.TYPES) {
                if (token.hasSourceInfo()) {
                    this.skipCurrentFileName();
                    this.skipCurrentLine();
                }
                this.tokenizer.readClose();
            }
        }
        catch (InvalidTokenException e) {
            throw new ParseException("Unexpected token " + token.toString() + " while expecting node.", e);
        }
    }

    @CheckForNull
    public <T extends NNode> T readNode(@Nonnull Class<T> nodeClass) throws IOException, JayceFormatException {
        NNode node;
        String fileName = this.readCurrentFileName();
        int startLine = this.readCurrentLine();
        this.readCatchBlockIds();
        Token token = this.tokenizer.next();
        if (token == Token.NULL) {
            return null;
        }
        this.tokenizer.readOpen();
        try {
            Percent statistic = null;
            if (token == Token.METHOD_BODY) {
                statistic = this.tracer.getStatistic(SKIPPED_BODY);
            }
            if (!this.nodeLevel.keep(token.getNodeLevel())) {
                this.skipNodeInternal(token);
                if (statistic != null) {
                    statistic.addTrue();
                }
                return null;
            }
            node = token.newNode();
            if (node instanceof NDeclaredType) {
                this.tracer.getStatistic(SKIPPED_TYPE_STRUCTURE).add(this.nodeLevel == NodeLevel.TYPES);
            }
            if (statistic != null) {
                statistic.addFalse();
            }
        }
        catch (InvalidTokenException e) {
            throw new ParseException("Unexpected token " + token.toString() + " while expecting node.", e);
        }
        assert (node != null);
        if (!nodeClass.isAssignableFrom(node.getClass())) {
            throw new JayceFormatException("Unexpected node " + node.getClass().getSimpleName() + ", " + nodeClass.getSimpleName() + " was expected.");
        }
        if (node instanceof HasCatchBlockIds) {
            ((HasCatchBlockIds)((Object)node)).setCatchBlockIds(new ArrayList<String>(this.currentCatchBlockList));
        }
        node.readContent(this);
        if (this.nodeLevel != NodeLevel.TYPES) {
            if (node instanceof HasSourceInfo) {
                fileName = this.readCurrentFileName();
                int endLine = this.readCurrentLine();
                if (fileName == null) {
                    assert (startLine == 0 && endLine == 0);
                    ((HasSourceInfo)((Object)node)).setSourceInfos(SourceInfo.UNKNOWN);
                } else {
                    assert (fileName != null);
                    ((HasSourceInfo)((Object)node)).setSourceInfos(this.sif.create(0, 0, startLine, endLine, fileName));
                }
            }
            assert (!(node instanceof NMethod) || this.currentCatchBlockList.isEmpty());
            this.tokenizer.readClose();
        }
        return (T)node;
    }

    @Nonnull
    public <T extends NNode> List<T> readNodes(@Nonnull Class<T> nodeClass) throws IOException, JayceFormatException {
        this.tokenizer.readOpen();
        int length = this.readInt();
        ArrayList<T> nodes = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            T node = this.readNode(nodeClass);
            if (node == null) continue;
            nodes.add(node);
        }
        this.tokenizer.readClose();
        return nodes;
    }

    public <T extends NNode> void skipNodes() throws IOException, JayceFormatException {
        this.tokenizer.readOpen();
        int length = this.readInt();
        for (int i = 0; i < length; ++i) {
            this.skipNode();
        }
        this.tokenizer.readClose();
    }

    public int readInt() throws IOException {
        return this.tokenizer.readInt();
    }

    public void skipInt() throws IOException {
        this.tokenizer.skipInt();
    }

    public byte readByte() throws IOException {
        return this.tokenizer.readByte();
    }

    public void skipByte() throws IOException {
        this.tokenizer.skipByte();
    }

    public boolean readBoolean() throws IOException {
        return this.tokenizer.readBoolean();
    }

    public void skipBoolean() throws IOException {
        this.tokenizer.skipBoolean();
    }

    public long readLong() throws IOException {
        return this.tokenizer.readLong();
    }

    public void skipLong() throws IOException {
        this.tokenizer.skipLong();
    }

    public short readShort() throws IOException {
        return this.tokenizer.readShort();
    }

    public void skipShort() throws IOException {
        this.tokenizer.skipShort();
    }

    public char readChar() throws IOException {
        return this.tokenizer.readChar();
    }

    public void skipChar() throws IOException {
        this.tokenizer.skipChar();
    }

    public float readFloat() throws IOException {
        return this.tokenizer.readFloat();
    }

    public void skipFloat() throws IOException {
        this.tokenizer.skipFloat();
    }

    public double readDouble() throws IOException {
        return this.tokenizer.readDouble();
    }

    public void skipDouble() throws IOException {
        this.tokenizer.skipDouble();
    }

    @Override
    @Nonnull
    public DeclaredTypeNode readType(@Nonnull NodeLevel nodeLevel) throws IOException, JayceFormatException {
        if (this.type == null) {
            this.nodeLevel = nodeLevel;
            this.type = this.readNode(NDeclaredType.class);
        }
        assert (this.type != null);
        return this.type;
    }

    @Override
    public int getCurrentMinor() {
        return 4;
    }

    @Override
    public int getMinorMin() {
        return 4;
    }
}

