/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.io;

import com.android.jack.google.common.io.ByteStreams;
import com.android.jack.jayce.v0004.io.ParseException;
import com.android.jack.util.StringUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

class JayceInputStream
implements DataInput {
    @Nonnull
    private final DataInputStream in;

    public JayceInputStream(InputStream in) {
        this.in = new DataInputStream(in);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public void skipBoolean() throws IOException {
        ByteStreams.skipFully(this.in, 1L);
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public void skipByte() throws IOException {
        ByteStreams.skipFully(this.in, 1L);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public void skipUnsignedByte() throws IOException {
        ByteStreams.skipFully(this.in, 1L);
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public void skipShort() throws IOException {
        ByteStreams.skipFully(this.in, 2L);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public void skipUnsignedShort() throws IOException {
        ByteStreams.skipFully(this.in, 2L);
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public void skipChar() throws IOException {
        ByteStreams.skipFully(this.in, 2L);
    }

    @Override
    public int readInt() throws IOException {
        byte cur;
        int result = 0;
        int count = 0;
        int signBits = -1;
        do {
            cur = this.readByte();
            result |= (cur & 0x7F) << count * 7;
            signBits <<= 7;
        } while ((cur & 0x80) == 128 && ++count < 5);
        if ((cur & 0x80) == 128) {
            throw new ParseException("invalid LEB128 sequence");
        }
        if ((signBits >> 1 & result) != 0) {
            result |= signBits;
        }
        return result;
    }

    public void skipInt() throws IOException {
        this.readInt();
    }

    @Override
    public long readLong() throws IOException {
        long cur;
        long result = 0L;
        int count = 0;
        long signBits = -1L;
        do {
            cur = this.readByte();
            result |= (cur & 0x7FL) << count * 7;
            signBits <<= 7;
        } while ((cur & 0x80L) == 128L && ++count < 10);
        if ((cur & 0x80L) == 128L) {
            throw new ParseException("invalid LEB128 sequence");
        }
        if ((signBits >> 1 & result) != 0L) {
            result |= signBits;
        }
        return result;
    }

    public void skipLong() throws IOException {
        this.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public void skipFloat() throws IOException {
        ByteStreams.skipFully(this.in, 4L);
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public void skipDouble() throws IOException {
        ByteStreams.skipFully(this.in, 8L);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        byte[] utf8String = new byte[length];
        this.in.readFully(utf8String);
        try {
            return StringUtils.utf8BytesToString(utf8String);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e);
        }
    }

    public void skipUTF() throws IOException {
        int length = this.readInt();
        if (length > 0) {
            ByteStreams.skipFully(this.in, length);
        }
    }

    public byte[] readBuffer() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        byte[] b = new byte[length];
        this.in.readFully(b);
        return b;
    }

    public void skipBuffer() throws IOException {
        int length = this.readInt();
        if (length > 0) {
            ByteStreams.skipFully(this.in, length);
        }
    }
}

