/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JSynchronizedBlock;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NBlock;
import com.android.jack.jayce.v0003.nodes.NExpression;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.jayce.v0003.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NSynchronizedBlock
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.SYNCHRONIZED_BLOCK;
    @CheckForNull
    public NExpression lockExpr;
    @CheckForNull
    public NBlock synchronizedBlock;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JSynchronizedBlock jSynchronizedBlock = (JSynchronizedBlock)node;
        this.lockExpr = (NExpression)loader.load(jSynchronizedBlock.getLockExpr());
        this.synchronizedBlock = (NBlock)loader.load(jSynchronizedBlock.getSynchronizedBlock());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jSynchronizedBlock.getJCatchBlocks());
        this.sourceInfo = loader.load(jSynchronizedBlock.getSourceInfo());
    }

    @Override
    @Nonnull
    public JSynchronizedBlock exportAsJast(@Nonnull ExportSession exportSession) throws JMethodLookupException, JTypeLookupException {
        assert (this.sourceInfo != null);
        assert (this.lockExpr != null);
        assert (this.synchronizedBlock != null);
        JExpression jLockExpr = this.lockExpr.exportAsJast(exportSession);
        JBlock jBlock = this.synchronizedBlock.exportAsJast(exportSession);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JSynchronizedBlock jSynchronizedBlock = new JSynchronizedBlock(jSourceInfo, jLockExpr, jBlock);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jSynchronizedBlock));
        }
        return jSynchronizedBlock;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.lockExpr = in.readNode(NExpression.class);
        this.synchronizedBlock = in.readNode(NBlock.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

