/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.JayceMethodLoader;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NAbstractMethodBody;
import com.android.jack.jayce.v0003.nodes.NAnnotation;
import com.android.jack.jayce.v0003.nodes.NMarker;
import com.android.jack.jayce.v0003.nodes.NMethod;
import com.android.jack.jayce.v0003.nodes.NParameter;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.Nonnull;

public class NConstructor
extends NMethod {
    @Nonnull
    public static final Token TOKEN = Token.CONSTRUCTOR;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object jElement) {
        JConstructor jConstructor = (JConstructor)jElement;
        this.setParameters(loader.load(NParameter.class, jConstructor.getParams()));
        this.modifier = jConstructor.getModifier();
        this.annotations = loader.load(NAnnotation.class, jConstructor.getAnnotations());
        this.body = (NAbstractMethodBody)loader.load(jConstructor.getBody());
        this.markers = loader.load(NMarker.class, jConstructor.getAllMarkers());
        this.sourceInfo = loader.load(jConstructor.getSourceInfo());
    }

    @Override
    @Nonnull
    public JConstructor exportAsJast(@Nonnull ExportSession exportSession) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public JMethod exportAsJast(@Nonnull ExportSession exportSession, @Nonnull JayceClassOrInterfaceLoader enclosingLoader) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.methodId != null);
        exportSession.getVariableResolver().clear();
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JDefinedClass enclosingType = (JDefinedClass)exportSession.getCurrentType();
        assert (enclosingType != null);
        JayceMethodLoader methodLoader = new JayceMethodLoader(this, this.methodId, enclosingLoader);
        JConstructor jConstructor = new JConstructor(jSourceInfo, enclosingType, this.modifier, methodLoader);
        exportSession.setCurrentMethod(jConstructor);
        for (NParameter parameter : this.getParameters()) {
            JParameter jParam = parameter.exportAsJast(exportSession, methodLoader);
            jConstructor.addParam(jParam);
            JMethodIdWide id = jConstructor.getMethodIdWide();
            id.addParam(jParam.getType());
        }
        for (NMarker marker : this.markers) {
            jConstructor.addMarker(marker.exportAsJast(exportSession));
        }
        NConstructor.clearBodyResolvers(exportSession);
        return jConstructor;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.level = in.getNodeLevel();
        this.setParameters(in.readNodes(NParameter.class));
        this.modifier = in.readInt();
        this.annotations = in.readNodes(NAnnotation.class);
        this.body = in.readNode(NAbstractMethodBody.class);
        this.markers = in.readNodes(NMarker.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public String getName() {
        return "<init>";
    }

    @Override
    @Nonnull
    public String getReturnType() {
        return "V";
    }
}

