/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NLiteral;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NStringLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.STRING_LITERAL;
    @CheckForNull
    public String value;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JAbstractStringLiteral jStringLiteral = (JAbstractStringLiteral)node;
        this.value = jStringLiteral.getValue();
        this.sourceInfo = loader.load(jStringLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JAbstractStringLiteral exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        assert (this.value != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JStringLiteral jStringLiteral = new JStringLiteral(jSourceInfo, this.value);
        return jStringLiteral;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.value = in.readString();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

