/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.jayce.v0002.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NLabeledStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.LABELED_STATEMENT;
    @CheckForNull
    public String label;
    @CheckForNull
    public String id;
    @CheckForNull
    public NStatement body;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JLabeledStatement jLabeled = (JLabeledStatement)node;
        this.label = jLabeled.getLabel().getName();
        this.id = loader.getLabelSymbols().getId(jLabeled);
        this.body = (NStatement)loader.load(jLabeled.getBody());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jLabeled.getJCatchBlocks());
        this.sourceInfo = loader.load(jLabeled.getSourceInfo());
    }

    @Override
    @Nonnull
    public JLabeledStatement exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.body != null);
        assert (this.id != null);
        assert (this.label != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JLabeledStatement jLabeled = new JLabeledStatement(jSourceInfo, new JLabel(jSourceInfo, this.label), this.body.exportAsJast(exportSession));
        exportSession.getLabelResolver().addTarget(this.id, jLabeled);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jLabeled));
        }
        return jLabeled;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.label = in.readString();
        this.id = in.readId();
        this.body = in.readNode(NStatement.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

