/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.jayce.DeclaredTypeNode;
import com.android.jack.jayce.FieldNode;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.MethodNode;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0002.NNode;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.nodes.HasSourceInfo;
import com.android.jack.jayce.v0002.nodes.NAnnotation;
import com.android.jack.jayce.v0002.nodes.NField;
import com.android.jack.jayce.v0002.nodes.NMethod;
import com.android.jack.jayce.v0002.nodes.NParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class NDeclaredType
extends NNode
implements HasSourceInfo,
DeclaredTypeNode {
    @CheckForNull
    protected NodeLevel level;
    @Nonnull
    private Map<String, NMethod> methods = Collections.emptyMap();
    @Nonnull
    private Map<String, NField> fields = Collections.emptyMap();
    @Nonnull
    public List<NAnnotation> annotations = Collections.emptyList();

    @Override
    @Nonnull
    public abstract JDefinedClassOrInterface exportAsJast(@Nonnull ExportSession var1);

    @Override
    @Nonnull
    public NodeLevel getLevel() {
        assert (this.level != null);
        return this.level;
    }

    @Override
    public void loadAnnotations(@Nonnull JDefinedClassOrInterface loading, @Nonnull JayceClassOrInterfaceLoader loader) {
        if (!this.annotations.isEmpty()) {
            ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
            for (NAnnotation annotation : this.annotations) {
                JAnnotation annotationLiteral = annotation.exportAsJast(exportSession);
                loading.addAnnotation(annotationLiteral);
                annotationLiteral.updateParents(loading);
            }
        }
    }

    @Override
    @Nonnull
    public FieldNode getFieldNode(@Nonnull String fieldId) {
        return this.fields.get(fieldId);
    }

    @Override
    @Nonnull
    public MethodNode getMethodNode(@Nonnull String methodId) {
        return this.methods.get(methodId);
    }

    @Nonnull
    public Collection<NMethod> getMethods() {
        return this.methods.values();
    }

    public void setMethods(@Nonnull List<NMethod> methods) {
        this.methods = new HashMap<String, NMethod>(methods.size() + 1, 1.0f);
        for (NMethod nMethod : methods) {
            assert (nMethod.getName() != null);
            StringBuilder builder = new StringBuilder(nMethod.getName()).append('(');
            for (NParameter param : nMethod.getParameters()) {
                assert (param.type != null);
                builder.append(param.type);
            }
            assert (nMethod.getReturnType() != null);
            builder.append(')').append(nMethod.getReturnType());
            String id = builder.toString();
            this.methods.put(id, nMethod);
            nMethod.setId(id);
        }
    }

    @Nonnull
    public Collection<NField> getFields() {
        return this.fields.values();
    }

    public void setFields(@Nonnull List<NField> fields) {
        this.fields = new HashMap<String, NField>(fields.size() + 1, 1.0f);
        for (NField nField : fields) {
            assert (nField.name != null);
            assert (nField.type != null);
            String id = nField.name + '-' + nField.type;
            this.fields.put(id, nField);
            nField.setId(id);
        }
    }
}

