/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JContinueStatement;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.jayce.v0002.nodes.NStatement;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NContinueStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.CONTINUE_STATEMENT;
    @CheckForNull
    public String label;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JContinueStatement jContinueStatement = (JContinueStatement)node;
        this.label = ImportHelper.getLabelName(jContinueStatement.getLabel());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jContinueStatement.getJCatchBlocks());
        this.sourceInfo = loader.load(jContinueStatement.getSourceInfo());
    }

    @Override
    @Nonnull
    public JContinueStatement exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JLabel jLabel = this.label == null ? null : new JLabel(jSourceInfo, this.label);
        JContinueStatement jContinueStatement = new JContinueStatement(jSourceInfo, jLabel);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jContinueStatement));
        }
        return jContinueStatement;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.label = in.readString();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

