/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NAnnotation;
import com.android.jack.jayce.v0002.nodes.NField;
import com.android.jack.jayce.v0002.nodes.NInterfaceType;
import com.android.jack.jayce.v0002.nodes.NMarker;
import com.android.jack.jayce.v0002.nodes.NMethod;
import com.android.jack.util.NamingTools;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NAnnotationType
extends NInterfaceType {
    @Nonnull
    public static final Token TOKEN = Token.ANNOTATION_TYPE;
    @CheckForNull
    public JRetentionPolicy retentionPolicy;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JDefinedAnnotationType jAnnotationType = (JDefinedAnnotationType)node;
        this.retentionPolicy = jAnnotationType.getRetentionPolicy();
        this.modifiers = jAnnotationType.getModifier();
        this.signature = ImportHelper.getSignatureName(jAnnotationType);
        this.superInterfaces = ImportHelper.getSignatureNameList(jAnnotationType.getImplements());
        this.enclosingType = ImportHelper.getSignatureName(jAnnotationType.getEnclosingType());
        this.inners = ImportHelper.getSignatureNameList(jAnnotationType.getMemberTypes());
        this.setFields(loader.load(NField.class, jAnnotationType.getFields()));
        this.setMethods(loader.load(NMethod.class, jAnnotationType.getMethods()));
        this.annotations = loader.load(NAnnotation.class, jAnnotationType.getAnnotations());
        this.markers = loader.load(NMarker.class, jAnnotationType.getAllMarkers());
        this.sourceInfo = loader.load(jAnnotationType.getSourceInfo());
    }

    @Override
    @Nonnull
    public JDefinedAnnotationType exportAsJast(@Nonnull ExportSession exportSession) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public JDefinedAnnotationType create(@Nonnull JPackage enclosingPackage, @Nonnull JayceClassOrInterfaceLoader loader) {
        assert (this.signature != null);
        assert (this.retentionPolicy != null);
        String binaryName = NamingTools.getClassBinaryNameFromDescriptor(this.signature);
        String simpleName = NamingTools.getSimpleClassNameFromBinaryName(binaryName);
        JDefinedAnnotationType jInterfaceType = new JDefinedAnnotationType(SourceInfo.UNKNOWN, simpleName, this.modifiers, enclosingPackage, loader);
        jInterfaceType.setRetentionPolicy(this.retentionPolicy);
        return jInterfaceType;
    }

    @Override
    public void loadStructure(@Nonnull JDefinedClassOrInterface loading, @Nonnull JayceClassOrInterfaceLoader loader) {
        assert (this.sourceInfo != null);
        assert (this.signature != null);
        JDefinedAnnotationType jInterfaceType = (JDefinedAnnotationType)loading;
        ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
        exportSession.setCurrentType(jInterfaceType);
        loading.setSourceInfo(this.sourceInfo.exportAsJast(exportSession));
        for (String superInterface : this.superInterfaces) {
            jInterfaceType.addImplements(exportSession.getLookup().getInterface(superInterface));
        }
        if (this.enclosingType != null) {
            jInterfaceType.setEnclosingType((JClassOrInterface)exportSession.getLookup().getType(this.enclosingType));
        }
        for (String memberType : this.inners) {
            jInterfaceType.addMemberType((JClassOrInterface)exportSession.getLookup().getType(memberType));
        }
        for (NField field : this.getFields()) {
            JField jField = field.exportAsJast(exportSession, loader);
            jInterfaceType.addField(jField);
        }
        for (NMethod method : this.getMethods()) {
            JMethod jMethod = method.exportAsJast(exportSession, loader);
            jInterfaceType.addMethod(jMethod);
        }
        for (NMarker marker : this.markers) {
            jInterfaceType.addMarker(marker.exportAsJast(exportSession));
        }
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.level = in.getNodeLevel();
        this.retentionPolicy = in.readRetentionPolicyEnum();
        this.modifiers = in.readInt();
        this.signature = in.readId();
        if (this.level != NodeLevel.TYPES) {
            this.superInterfaces = in.readIds();
            this.enclosingType = in.readId();
            this.inners = in.readIds();
            this.setFields(in.readNodes(NField.class));
            this.setMethods(in.readNodes(NMethod.class));
            this.annotations = in.readNodes(NAnnotation.class);
            this.markers = in.readNodes(NMarker.class);
        }
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

