/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.sourceinfo;

import com.android.jack.ir.sourceinfo.ColumnSourceInfo;
import com.android.jack.ir.sourceinfo.FileSourceInfo;
import com.android.jack.ir.sourceinfo.LineSourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfoCreation;
import com.android.sched.schedulable.Constraint;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Constraint(need={SourceInfoCreation.class})
public class SourceInfoFactory {
    @Nonnull
    private final ConcurrentHashMap<String, FileSourceInfo> canonicalFileSourceInfos = new ConcurrentHashMap();
    @Nonnull
    private final ConcurrentHashMap<LineSourceInfo, LineSourceInfo> canonicalLineSourceInfos = new ConcurrentHashMap();
    @Nonnull
    private final ConcurrentHashMap<ColumnSourceInfo, ColumnSourceInfo> canonicalColumnSourceInfos = new ConcurrentHashMap();

    @Nonnull
    public FileSourceInfo create(@Nonnull String fileName) {
        FileSourceInfo previousValue;
        assert (fileName != null);
        FileSourceInfo newInstance = this.canonicalFileSourceInfos.get(fileName);
        if (newInstance == null && (previousValue = this.canonicalFileSourceInfos.putIfAbsent(fileName, newInstance = new FileSourceInfo(fileName))) != null) {
            newInstance = previousValue;
        }
        return newInstance;
    }

    @Nonnull
    public SourceInfo create(@Nonnegative int startCol, @Nonnegative int endCol, @Nonnegative int startLine, @Nonnegative int endLine, @Nonnull String fileName) {
        SourceInfo si = this.create(startLine, endLine, fileName);
        if (startCol == 0 || si instanceof FileSourceInfo) {
            assert (endCol == 0);
            return si;
        }
        ColumnSourceInfo newInstance = new ColumnSourceInfo((LineSourceInfo)si, startCol, endCol);
        ColumnSourceInfo canonical = this.canonicalColumnSourceInfos.get(newInstance);
        assert (canonical == null || newInstance != canonical && newInstance.equals(canonical));
        if (canonical != null) {
            return canonical;
        }
        ColumnSourceInfo previousValue = this.canonicalColumnSourceInfos.putIfAbsent(newInstance, newInstance);
        if (previousValue != null) {
            newInstance = previousValue;
        }
        return newInstance;
    }

    @Nonnull
    public SourceInfo create(@Nonnegative int startLine, @Nonnegative int endLine, @Nonnull String fileName) {
        FileSourceInfo fileSourceInfo = this.create(fileName);
        if (startLine == 0) {
            assert (endLine == 0);
            return fileSourceInfo;
        }
        return this.create(startLine, endLine, fileSourceInfo);
    }

    @Nonnull
    public SourceInfo create(@Nonnegative int startLine, @Nonnegative int endLine, @Nonnull SourceInfo originalSourceInfo) {
        if (originalSourceInfo == SourceInfo.UNKNOWN) {
            assert (startLine == 0);
            assert (endLine == 0);
            return SourceInfo.UNKNOWN;
        }
        LineSourceInfo newInstance = new LineSourceInfo(originalSourceInfo.getFileSourceInfo(), startLine, endLine);
        LineSourceInfo canonical = this.canonicalLineSourceInfos.get(newInstance);
        assert (canonical == null || newInstance != canonical && newInstance.equals(canonical));
        if (canonical != null) {
            return canonical;
        }
        LineSourceInfo previousValue = this.canonicalLineSourceInfos.putIfAbsent(newInstance, newInstance);
        if (previousValue != null) {
            newInstance = previousValue;
        }
        return newInstance;
    }

    @Nonnull
    public Collection<FileSourceInfo> getFileSourceInfos() {
        return this.canonicalFileSourceInfos.values();
    }

    @Nonnull
    public Set<ColumnSourceInfo> getColumnSourceInfos() {
        return this.canonicalColumnSourceInfos.keySet();
    }

    @Nonnull
    public Set<LineSourceInfo> getLineSourceInfos() {
        return this.canonicalLineSourceInfos.keySet();
    }
}

