/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.impl;

import com.android.jack.Jack;
import com.android.jack.eclipse.jdt.core.compiler.CharOperation;
import com.android.jack.eclipse.jdt.internal.compiler.ast.ASTNode;
import com.android.jack.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import com.android.jack.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import com.android.jack.eclipse.jdt.internal.compiler.ast.Argument;
import com.android.jack.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import com.android.jack.eclipse.jdt.internal.compiler.impl.Constant;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import com.android.jack.google.common.annotations.VisibleForTesting;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JEnumField;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.ast.MissingJTypeLookupException;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.ir.ast.marker.ThrownExceptionMarker;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.ir.impl.CudInfo;
import com.android.jack.ir.impl.JackIrBuilder;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfoFactory;
import com.android.jack.lookup.JLookup;
import com.android.jack.lookup.JNodeLookup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ReferenceMapper {
    @Nonnull
    private final List<String> argNames = new ArrayList<String>();
    @Nonnull
    private final Map<SignatureKey, JField> fields = new HashMap<SignatureKey, JField>();
    @Nonnull
    private final Map<SignatureKey, JMethod> methods = new HashMap<SignatureKey, JMethod>();
    @Nonnull
    private static final StringInterner stringInterner = StringInterner.get();
    @Nonnull
    private final TypePackageAndMethodFormatter lookupFormater;
    @CheckForNull
    private JDefinedClass javaLangString;
    @Nonnull
    private final JNodeLookup lookup;
    @Nonnull
    private final LookupEnvironment lookupEnvironment;
    @Nonnull
    private final SourceInfoFactory sourceInfoFactory;
    @CheckForNull
    private ReferenceBinding ecjJlo = null;
    @CheckForNull
    private MethodBinding ecjJloCloneMth = null;

    public ReferenceMapper(@Nonnull JNodeLookup lookup, @Nonnull LookupEnvironment lookupEnvironment, @Nonnull SourceInfoFactory sourceInfoFactory) {
        this.lookup = lookup;
        this.lookupEnvironment = lookupEnvironment;
        this.sourceInfoFactory = sourceInfoFactory;
        this.lookupFormater = Jack.getLookupFormatter();
    }

    @Nonnull
    public LookupEnvironment getLookupEnvironment() {
        return this.lookupEnvironment;
    }

    @Nonnull
    public SourceInfoFactory getSourceInfoFactory() {
        return this.sourceInfoFactory;
    }

    @Nonnull
    public JLookup getLookup() {
        return this.lookup;
    }

    @Nonnull
    public JField get(@Nonnull FieldBinding binding) throws JTypeLookupException {
        SignatureKey key = new SignatureKey(binding = binding.original());
        JField field = this.fields.get(key);
        if (field == null) {
            if (binding.declaringClass instanceof SourceTypeBinding) {
                field = this.createField(binding);
            } else {
                JDefinedClassOrInterface enclosingType = (JDefinedClassOrInterface)this.get(binding.declaringClass);
                field = this.findField(binding, enclosingType);
                assert (field != null);
            }
            this.cacheField(key, field);
        }
        return field;
    }

    private boolean isCloneOfArray(@Nonnull MethodBinding binding) {
        if (this.ecjJlo == null) {
            this.ecjJlo = this.lookupEnvironment.getType(TypeConstants.JAVA_LANG_OBJECT);
            assert (this.ecjJlo != null);
            MethodBinding[] methods = this.ecjJlo.getMethods("clone".toCharArray());
            assert (methods.length == 1);
            this.ecjJloCloneMth = methods[0];
        }
        return binding.declaringClass.equals(this.ecjJlo) && new String(binding.selector).equals("clone") && binding.returnType.isArrayType();
    }

    @Nonnull
    public JMethod get(@Nonnull MethodBinding binding) throws JTypeLookupException {
        SignatureKey key;
        JMethod method;
        if (this.isCloneOfArray(binding)) {
            binding = this.ecjJloCloneMth;
            assert (binding != null);
        }
        if ((method = this.methods.get(key = new SignatureKey(binding = binding.original()))) == null) {
            if (binding.declaringClass instanceof SourceTypeBinding) {
                method = this.createMethod(binding);
            } else {
                JDefinedClassOrInterface enclosingType = (JDefinedClassOrInterface)this.get(binding.declaringClass);
                method = this.findMethod(binding, enclosingType);
                if (method == null) {
                    assert (binding instanceof SyntheticMethodBinding);
                    method = this.createMethod(binding);
                }
            }
            this.cacheMethod(key, method);
        }
        return method;
    }

    @Nonnull
    public List<JType> getBounds(@Nonnull IntersectionTypeBinding18 binding) throws JTypeLookupException {
        ArrayList<JType> bounds = new ArrayList<JType>(binding.intersectingTypes.length);
        for (ReferenceBinding refBinding : binding.intersectingTypes) {
            bounds.add(this.get(refBinding));
        }
        return bounds;
    }

    @Nonnull
    public JType get(@Nonnull TypeBinding binding) throws JTypeLookupException {
        binding = binding.erasure();
        assert (!(binding instanceof IntersectionTypeBinding18));
        return this.get(new String(binding.signature()));
    }

    @Nonnull
    static String intern(@Nonnull char[] cs) {
        return ReferenceMapper.intern(String.valueOf(cs));
    }

    @Nonnull
    static String intern(@Nonnull String s) {
        return stringInterner.intern(s);
    }

    @Nonnull
    public JType get(@Nonnull String signature) throws JTypeLookupException {
        return this.lookup.getType(signature);
    }

    void setField(@Nonnull FieldBinding binding, @Nonnull JField field) {
        this.cacheField(new SignatureKey(binding), field);
    }

    @Nonnull
    private JMethod createMethod(@Nonnull MethodBinding b) throws JTypeLookupException {
        NestedTypeBinding nestedBinding;
        JMethod method;
        SourceInfo info;
        CudInfo cuInfo;
        AbstractMethodDeclaration declaration = this.getDeclaration(b);
        if (declaration != null) {
            cuInfo = new CudInfo(declaration.scope.referenceCompilationUnit());
            b = declaration.binding;
            info = ReferenceMapper.makeSourceInfo(cuInfo, declaration, this.sourceInfoFactory);
        } else {
            cuInfo = null;
            info = SourceInfo.UNKNOWN;
        }
        ReferenceBinding declaringClass = (ReferenceBinding)b.declaringClass.erasure();
        HashSet<String> alreadyNamedVariables = new HashSet<String>();
        JDefinedClassOrInterface enclosingType = (JDefinedClassOrInterface)this.get(declaringClass);
        boolean isNested = JackIrBuilder.isNested(declaringClass);
        int flags = b.getAccessFlags();
        flags &= 0xFFFEFFFF;
        if (b.isDeprecated()) {
            flags |= 0x100000;
        }
        if (b.isConstructor()) {
            method = new JConstructor(info, (JDefinedClass)enclosingType, flags);
            if (declaringClass.isEnum()) {
                this.createParameter(info, method, "enum$name", this.lookupEnvironment.getType(TypeConstants.JAVA_LANG_STRING), 0x401000);
                this.createParameter(info, method, "enum$ordinal", TypeBinding.INT, 0x401000);
            }
            if (isNested) {
                nestedBinding = (NestedTypeBinding)declaringClass;
                this.createParameters(nestedBinding.enclosingInstances, info, method, alreadyNamedVariables, !nestedBinding.isAnonymousType() || !nestedBinding.superclass().isLocalType());
            }
        } else {
            JType returnType = this.get(b.returnType);
            method = declaringClass.isAnnotationType() ? new JAnnotationMethod(info, new JMethodId(new JMethodIdWide(ReferenceMapper.intern(b.selector), MethodKind.INSTANCE_VIRTUAL), returnType), enclosingType, ReferenceMapper.removeSynchronizedOnBridge(flags)) : new JMethod(info, new JMethodId(new JMethodIdWide(ReferenceMapper.intern(b.selector), ReferenceMapper.getMethodKind(flags)), returnType), enclosingType, ReferenceMapper.removeSynchronizedOnBridge(flags));
        }
        if (declaration != null) {
            assert (cuInfo != null);
            this.createParameters(method, declaration, cuInfo);
        } else {
            this.mapParameters(info, method, b, 0);
        }
        if (b.isConstructor() && isNested) {
            nestedBinding = (NestedTypeBinding)declaringClass;
            this.createParameters(nestedBinding.outerLocalVariables, info, method, alreadyNamedVariables, false);
        }
        this.mapExceptions(method, b);
        if (b.isSynthetic()) {
            method.setSynthetic();
        }
        enclosingType.addMethod(method);
        char[] genSignature = b.genericSignature();
        if (genSignature != null) {
            method.addMarker(new GenericSignature(ReferenceMapper.intern(genSignature)));
        }
        method.updateParents(enclosingType);
        return method;
    }

    @CheckForNull
    private AbstractMethodDeclaration getDeclaration(@Nonnull MethodBinding b) {
        if (b instanceof SyntheticMethodBinding || b.isSynthetic()) {
            return null;
        }
        AbstractMethodDeclaration declaration = b.sourceMethod();
        if (declaration == null) {
            SourceTypeBinding sourceType = (SourceTypeBinding)b.declaringClass;
            for (AbstractMethodDeclaration candidate : sourceType.scope.referenceContext.methods) {
                if (!CharOperation.equals(candidate.selector, b.selector) || !CharOperation.equals(candidate.binding.signature(), b.signature())) continue;
                declaration = candidate;
                break;
            }
            assert (declaration != null);
        }
        return declaration;
    }

    private void createParameters(@CheckForNull SyntheticArgumentBinding[] sab, @Nonnull SourceInfo info, @Nonnull JMethod method, @Nonnull Set<String> alreadyNamedVariables, boolean forceToImplicit) {
        if (sab != null) {
            for (int i = 0; i < sab.length; ++i) {
                SyntheticArgumentBinding arg = sab[i];
                String argName = String.valueOf(arg.name);
                if (alreadyNamedVariables.contains(argName)) {
                    argName = argName + "_" + i;
                }
                this.createParameter(info, method, argName, arg.type, this.getFinalModifier(arg) | (forceToImplicit ? 32768 : 4096) | 0x400000);
                alreadyNamedVariables.add(argName);
            }
        }
    }

    private void createParameters(@Nonnull JMethod method, @Nonnull AbstractMethodDeclaration x, @Nonnull CudInfo cuInfo) throws JTypeLookupException {
        if (x.arguments != null) {
            for (Argument argument : x.arguments) {
                SourceInfo info = ReferenceMapper.makeSourceInfo(cuInfo, argument, this.sourceInfoFactory);
                LocalVariableBinding binding = argument.binding;
                this.createParameter(info, method, ReferenceMapper.intern(binding.name), binding.type, this.getFinalModifier(binding) | 0x400000);
            }
        }
    }

    private int getFinalModifier(@Nonnull LocalVariableBinding lvBinding) {
        return lvBinding.isFinal() ? 16 : 0;
    }

    @Nonnull
    public JParameter createParameter(@Nonnull SourceInfo info, @Nonnull JMethod method, @Nonnull String name, @Nonnull TypeBinding typeBinding, int modifier) {
        return this.createParameter(info, method, name, typeBinding, modifier, method.getParams().size());
    }

    @Nonnull
    public JParameter createParameter(@Nonnull SourceInfo info, @Nonnull JMethod method, @Nonnull String name, @Nonnull TypeBinding typeBinding, int modifier, int paramIndex) throws JTypeLookupException {
        JType type = this.get(typeBinding);
        JParameter param = new JParameter(info, name, type, modifier, method);
        method.getParams().add(paramIndex, param);
        method.getMethodIdWide().getParamTypes().add(paramIndex, type);
        this.addGenericSignatureMarker(typeBinding, param);
        assert (method.getParams().size() == method.getMethodIdWide().getParamTypes().size());
        return param;
    }

    public void addGenericSignatureMarker(@Nonnull TypeBinding typeBinding, @Nonnull JVariable variable) {
        char[] genericSignature;
        char[] signature;
        char[] genericTypeSignature = typeBinding.genericTypeSignature();
        if (genericTypeSignature != null && !CharOperation.equals(signature = typeBinding.signature(), genericSignature = typeBinding.genericTypeSignature())) {
            variable.addMarker(new GenericSignature(ReferenceMapper.intern(genericSignature)));
        }
    }

    @Nonnull
    private JField createField(@Nonnull FieldBinding binding) throws JTypeLookupException {
        JField field;
        FieldDeclaration sourceField = binding.sourceField();
        CudInfo cuInfo = new CudInfo(((SourceTypeBinding)binding.declaringClass).scope.referenceCompilationUnit());
        SourceInfo info = ReferenceMapper.makeSourceInfo(cuInfo, sourceField, this.sourceInfoFactory);
        JType type = this.get(binding.type);
        JDefinedClassOrInterface enclosingType = (JDefinedClassOrInterface)this.get(binding.declaringClass);
        if (sourceField.initialization != null && sourceField.initialization instanceof AllocationExpression && ((AllocationExpression)sourceField.initialization).enumConstant != null) {
            field = new JEnumField(info, ReferenceMapper.intern(binding.name), binding.original().id, (JDefinedEnum)enclosingType, (JDefinedClass)type);
        } else {
            int flags = binding.getAccessFlags();
            if (binding.isDeprecated()) {
                flags |= 0x100000;
            }
            if (ReferenceMapper.isCompileTimeConstant(binding)) {
                flags |= 0x20000;
            }
            field = new JField(info, ReferenceMapper.intern(binding.name), enclosingType, type, flags);
        }
        enclosingType.addField(field);
        char[] genSignature = binding.genericSignature();
        if (genSignature != null) {
            field.addMarker(new GenericSignature(ReferenceMapper.intern(genSignature)));
        }
        field.updateParents(enclosingType);
        return field;
    }

    @Nonnull
    static JRetentionPolicy getRetentionPolicy(long tagBits) {
        long annotBits = tagBits & 0x300000000000L;
        JRetentionPolicy result = (annotBits ^ 0x100000000000L) == 0L ? JRetentionPolicy.SOURCE : ((annotBits ^ 0x300000000000L) == 0L ? JRetentionPolicy.RUNTIME : JRetentionPolicy.CLASS);
        return result;
    }

    private void ensureArgNames(int required) {
        for (int i = this.argNames.size(); i <= required; ++i) {
            this.argNames.add(ReferenceMapper.intern("arg" + i));
        }
    }

    private void mapExceptions(JMethod method, MethodBinding binding) throws JTypeLookupException {
        ReferenceBinding[] thrownExceptions = binding.thrownExceptions;
        int length = thrownExceptions.length;
        if (length != 0) {
            ArrayList<JClass> thrownException = new ArrayList<JClass>(length);
            for (ReferenceBinding thrownBinding : thrownExceptions) {
                JDefinedClass type = (JDefinedClass)this.get(thrownBinding);
                thrownException.add(type);
            }
            method.addMarker(new ThrownExceptionMarker(thrownException));
        }
    }

    private int mapParameters(SourceInfo info, JMethod method, MethodBinding binding, int argPosition) throws JTypeLookupException {
        if (binding.parameters != null) {
            this.ensureArgNames(argPosition + binding.parameters.length);
            for (TypeBinding argType : binding.parameters) {
                this.createParameter(info, method, this.argNames.get(argPosition++), argType, 0);
            }
        }
        return argPosition;
    }

    @Nonnull
    private static String getTypeConstantPoolName(@Nonnull String typeName) {
        assert (typeName.charAt(0) == 'L') : typeName + " is not well formed.";
        assert (typeName.charAt(typeName.length() - 1) == ';') : typeName + " is not well formed.";
        return typeName.substring(1, typeName.length() - 1);
    }

    @Nonnull
    public static ReferenceBinding getEcjType(@Nonnull String typeName, @Nonnull LookupEnvironment lookupEnvironment) throws JTypeLookupException {
        String typeNameWithDot = ReferenceMapper.getTypeConstantPoolName(typeName);
        char[][] compoundName = CharOperation.splitOn('/', typeNameWithDot.toCharArray());
        ReferenceBinding refBinding = lookupEnvironment.getType(compoundName);
        if (refBinding instanceof ProblemReferenceBinding) {
            ProblemReferenceBinding problem = (ProblemReferenceBinding)refBinding;
            ReferenceBinding closestMatch = problem.closestReferenceMatch();
            if (closestMatch != null && typeName.equals(new String(closestMatch.signature()))) {
                assert (closestMatch.isNestedType());
                refBinding = closestMatch;
            } else {
                refBinding = null;
            }
        }
        if (refBinding == null) {
            throw new MissingJTypeLookupException(typeName);
        }
        return refBinding;
    }

    static int removeSynchronizedOnBridge(int accessFlags) {
        if (JModifier.isBridge(accessFlags)) {
            accessFlags &= 0xFFFFFFDF;
        }
        return accessFlags;
    }

    @Nonnull
    static MethodKind getMethodKind(int accessFlags) {
        if (JModifier.isStatic(accessFlags)) {
            return MethodKind.STATIC;
        }
        if (JModifier.isPrivate(accessFlags)) {
            return MethodKind.INSTANCE_NON_VIRTUAL;
        }
        return MethodKind.INSTANCE_VIRTUAL;
    }

    @CheckForNull
    private JField findField(@Nonnull FieldBinding binding, @Nonnull JDefinedClassOrInterface enclosingType) {
        JField field = null;
        String name = new String(binding.name);
        String typeSignature = new String(binding.type.signature());
        for (JField existing : enclosingType.getFields()) {
            if (!name.equals(existing.getName()) || !typeSignature.equals(Jack.getLookupFormatter().getName(existing.getType()))) continue;
            field = existing;
            break;
        }
        return field;
    }

    @CheckForNull
    private JMethod findMethod(@Nonnull MethodBinding binding, @Nonnull JDefinedClassOrInterface enclosingType) {
        JMethod method = null;
        String paramsSignature = new String(binding.signature());
        String searchedSignature = new String(binding.selector) + paramsSignature;
        int paramsCount = ReferenceMapper.countParams(paramsSignature);
        for (JMethod existing : enclosingType.getMethods()) {
            if (!this.equals(paramsCount, searchedSignature, existing)) continue;
            method = existing;
            break;
        }
        return method;
    }

    @Nonnegative
    @VisibleForTesting
    static int countParams(@Nonnull String signature) {
        int result = 0;
        block5: for (int pos = 1; pos < signature.length() && signature.charAt(pos) != ')'; ++pos) {
            switch (signature.charAt(pos)) {
                case 'L': {
                    while (++pos < signature.length() && signature.charAt(pos) != ';') {
                    }
                    assert (pos < signature.length() && signature.charAt(pos) == ';');
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++result;
                    continue block5;
                }
                case '[': {
                    continue block5;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return result;
    }

    private boolean equals(@Nonnegative int paramsCount, @Nonnull String bindingSignature, @Nonnull JMethod method) {
        if (paramsCount != method.getParams().size() || !bindingSignature.startsWith(method.getName())) {
            return false;
        }
        return bindingSignature.equals(this.lookupFormater.getName(method));
    }

    static SourceInfo makeSourceInfo(@Nonnull CudInfo cuInfo, @Nonnull AbstractMethodDeclaration x, @Nonnull SourceInfoFactory factory) {
        return JackIrBuilder.makeSourceInfo(cuInfo, x.declarationSourceStart, x.declarationSourceEnd, factory);
    }

    static SourceInfo makeSourceInfo(@Nonnull CudInfo cuInfo, @Nonnull ASTNode x, @Nonnull SourceInfoFactory factory) {
        return JackIrBuilder.makeSourceInfo(cuInfo, x.sourceStart, x.sourceEnd, factory);
    }

    static boolean isCompileTimeConstant(@Nonnull FieldBinding binding) {
        boolean isCompileTimeConstant;
        assert (!binding.isFinal() || !binding.isVolatile());
        boolean bl = isCompileTimeConstant = binding.isStatic() && binding.isFinal() && binding.constant() != Constant.NotAConstant;
        if (isCompileTimeConstant) assert (binding.type.isBaseType() || binding.type.id == 11);
        return isCompileTimeConstant;
    }

    private void cacheMethod(@Nonnull SignatureKey key, @Nonnull JMethod method) {
        assert (!this.methods.containsKey(key));
        this.methods.put(key, method);
    }

    private void cacheField(@Nonnull SignatureKey key, @Nonnull JField field) {
        assert (!this.fields.containsKey(key));
        this.fields.put(key, field);
    }

    private static class SignatureKey {
        private static final int PRIME = 277;
        @Nonnull
        private final char[] declaringClass;
        @Nonnull
        private final char[] name;
        @Nonnull
        private final char[] signature;
        @Nonnegative
        private final int hashCode;

        public SignatureKey(@Nonnull char[] declaringClass, @Nonnull char[] name, @Nonnull char[] signature) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.signature = signature;
            this.hashCode = SignatureKey.hash(declaringClass) ^ SignatureKey.hash(name) ^ SignatureKey.hash(signature);
        }

        private static int hash(@Nonnull char[] data) {
            int hash = 0;
            for (int i = 0; i < data.length; ++i) {
                hash = hash * 277 + data[i];
            }
            return hash;
        }

        public SignatureKey(@Nonnull MethodBinding binding) {
            this(binding.declaringClass.constantPoolName(), binding.selector, binding.signature());
        }

        public SignatureKey(@Nonnull FieldBinding binding) {
            this(binding.declaringClass.constantPoolName(), binding.name, binding.type.signature());
        }

        public final boolean equals(@CheckForNull Object obj) {
            if (!(obj instanceof SignatureKey)) {
                return false;
            }
            SignatureKey key = (SignatureKey)obj;
            return Arrays.equals(this.declaringClass, key.declaringClass) && Arrays.equals(this.name, key.name) && Arrays.equals(this.signature, key.signature);
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

