/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.formatter;

import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.CharSeparatedPackageFormatter;
import com.android.jack.ir.formatter.TypeAndMethodFormatter;
import java.util.List;
import javax.annotation.Nonnull;

public class BinarySignatureFormatter
extends CharSeparatedPackageFormatter
implements TypeAndMethodFormatter {
    @Nonnull
    private static final BinarySignatureFormatter formatter = new BinarySignatureFormatter();

    protected BinarySignatureFormatter() {
    }

    @Override
    protected char getPackageSeparator() {
        return '/';
    }

    @Nonnull
    public static BinarySignatureFormatter getFormatter() {
        return formatter;
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JType type) {
        if (type instanceof JClassOrInterface) {
            return this.getClassOrInterfaceName((JClassOrInterface)type);
        }
        if (type instanceof JArrayType) {
            return "[" + this.getName(((JArrayType)type).getElementType());
        }
        if (type instanceof JNullType) {
            return "N";
        }
        if (type instanceof JPrimitiveType) {
            switch (((JPrimitiveType)type).getPrimitiveTypeEnum()) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case CHAR: {
                    return "C";
                }
                case DOUBLE: {
                    return "D";
                }
                case FLOAT: {
                    return "F";
                }
                case INT: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case SHORT: {
                    return "S";
                }
                case VOID: {
                    return "V";
                }
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    @Nonnull
    protected String getClassOrInterfaceName(@Nonnull JClassOrInterface type) {
        JPackage enclosingPackage = type.getEnclosingPackage();
        assert (enclosingPackage != null);
        return this.getName(enclosingPackage, type.getName());
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JPackage enclosingPackage, @Nonnull String classOrInterfaceSimpleName) {
        StringBuilder sb = new StringBuilder("L");
        if (!enclosingPackage.isDefaultPackage()) {
            sb.append((CharSequence)this.getNameInternal(enclosingPackage));
            sb.append(this.getPackageSeparator());
        }
        sb.append(classOrInterfaceSimpleName).append(';');
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JMethod method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        sb.append('(');
        for (JParameter p : method.getParams()) {
            sb.append(this.getName(p.getType()));
        }
        sb.append(')');
        sb.append(this.getName(method.getType()));
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getNameWithoutReturnType(@Nonnull JMethodIdWide methodId) {
        return this.getNameWithoutReturnType(methodId.getName(), methodId.getParamTypes());
    }

    @Override
    @Nonnull
    public String getName(@Nonnull String methodName, @Nonnull List<? extends JType> argumentTypes, @Nonnull JType returnType) {
        return this.getNameWithoutReturnType(methodName, argumentTypes) + this.getName(returnType);
    }

    @Override
    @Nonnull
    public String getNameWithoutReturnType(@Nonnull String methodName, @Nonnull List<? extends JType> argumentTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        for (JType jType : argumentTypes) {
            sb.append(this.getName(jType));
        }
        sb.append(')');
        return sb.toString();
    }
}

