/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAbstractMethodCall;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Java method call expression")
public class JPolymorphicMethodCall
extends JAbstractMethodCall {
    @Nonnull
    private final JType callSiteReturnType;
    @Nonnull
    private final List<JType> callSiteParameterTypes;

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public JPolymorphicMethodCall(@Nonnull SourceInfo info, @Nonnull JExpression instance, @Nonnull JClassOrInterface receiverType, @Nonnull JMethodId methodId, @Nonnull JType callSiteReturnType, @Nonnull List<JType> callSiteParameterTypes) {
        super(info, instance, receiverType, methodId);
        assert (instance != null);
        assert (JPolymorphicMethodCall.isCallToPolymorphicMethod(receiverType, methodId));
        this.callSiteReturnType = callSiteReturnType;
        this.callSiteParameterTypes = callSiteParameterTypes;
    }

    public JType getReturnTypeOfPolymorphicMethod() {
        return super.getType();
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.callSiteReturnType;
    }

    @Nonnull
    public List<JType> getCallSiteParameterTypes() {
        return this.callSiteParameterTypes;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.visitChildren(schedule);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        JExpression instance = this.getInstance();
        if (instance == null) {
            throw new JNodeInternalError(this, "Call to method with polymorphic signature must not be static");
        }
        if (!this.getReceiverType().isSameType(instance.getType())) {
            throw new JNodeInternalError(this, "Receiver type mismatch with instance type");
        }
        if (this.callSiteParameterTypes.size() != this.getArgs().size()) {
            throw new JNodeInternalError(this, "Number of method call arguments does not match the number of call site parameters");
        }
    }

    @Override
    public boolean isCallToPolymorphicMethod() {
        return true;
    }
}

