/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.HasSourceInfo;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JVisitable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.impl.SourceGenerationVisitor;
import com.android.jack.ir.impl.ToStringGenerationVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.marker.collector.SubTreeMarkersCollector;
import com.android.jack.util.DefaultTextOutput;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.marker.LocalMarkerManager;
import com.android.sched.marker.Marker;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="AST Node")
public abstract class JNode
extends LocalMarkerManager
implements JVisitable,
HasSourceInfo,
Component {
    @Nonnull
    protected SourceInfo info;
    @CheckForNull
    protected JNode parent = null;

    protected JNode(@Nonnull SourceInfo info) {
        assert (info != null) : "SourceInfo must be provided for JNodes";
        this.info = info;
    }

    @CheckForNull
    public JNode getParent() {
        return this.parent;
    }

    @Nonnull
    public <T extends JNode> T getParent(@Nonnull Class<T> classToSearch) {
        JNode result;
        for (result = this.getParent(); result != null && !classToSearch.isAssignableFrom(result.getClass()); result = result.getParent()) {
        }
        if (result == null) {
            throw new NoSuchElementException();
        }
        return (T)result;
    }

    @Override
    @Nonnull
    public SourceInfo getSourceInfo() {
        return this.info;
    }

    public void setSourceInfo(@Nonnull SourceInfo info) {
        this.info = info;
    }

    public final String toSource() {
        DefaultTextOutput out = new DefaultTextOutput(false);
        SourceGenerationVisitor v = new SourceGenerationVisitor(out);
        v.accept(this);
        return out.toString();
    }

    public final String toString() {
        DefaultTextOutput out = new DefaultTextOutput(true);
        ToStringGenerationVisitor v = new ToStringGenerationVisitor(out);
        v.accept(this);
        String str = out.toString();
        SourceInfo sourceInfo = this.getSourceInfo();
        if (sourceInfo != SourceInfo.UNKNOWN) {
            str = str + " (" + this.getSourceInfo().toString() + ")";
        }
        return str;
    }

    public final void remove(@Nonnull JNode existingNode) throws UnsupportedOperationException, ClassCastException {
        this.removeImpl(existingNode);
    }

    public final void replace(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException, ClassCastException {
        this.replaceImpl(existingNode, newNode);
        newNode.updateParents(this);
    }

    public final void insertBefore(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException, ClassCastException {
        this.insertBeforeImpl(existingNode, newNode);
        newNode.updateParents(this);
    }

    public final void insertAfter(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException, ClassCastException {
        this.insertAfterImpl(existingNode, newNode);
        newNode.updateParents(this);
    }

    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        this.transform(existingNode, null, Transformation.REMOVE);
    }

    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        this.transform(existingNode, newNode, Transformation.REPLACE);
    }

    protected void insertBeforeImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        this.transform(existingNode, newNode, Transformation.INSERT_BEFORE);
    }

    protected void insertAfterImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        this.transform(existingNode, newNode, Transformation.INSERT_AFTER);
    }

    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull Transformation transformation) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support transformation '" + transformation.name() + "', existing: " + existingNode.getClass().getName() + ", new:  " + (newNode == null ? "<null>" : newNode.getClass().getName()));
    }

    protected static <T> boolean transform(@Nonnull List<T> list, @Nonnull JNode existingNode, @CheckForNull T newNode, @Nonnull Transformation transformation) {
        assert (existingNode != null);
        int indexOfExisting = list.indexOf(existingNode);
        if (indexOfExisting != -1) {
            switch (transformation) {
                case INSERT_AFTER: {
                    assert (newNode != null);
                    list.add(indexOfExisting + 1, newNode);
                    break;
                }
                case INSERT_BEFORE: {
                    assert (newNode != null);
                    list.add(indexOfExisting, newNode);
                    break;
                }
                case REPLACE: {
                    assert (newNode != null);
                    list.set(indexOfExisting, newNode);
                    break;
                }
                case REMOVE: {
                    assert (newNode == null);
                    list.remove(indexOfExisting);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return true;
        }
        return false;
    }

    public void updateParents(@Nonnull JNode parent) {
        new ParentSetterVisitor(parent).accept(this);
    }

    private void setParent(@Nonnull JNode parent) {
        assert (parent != null);
        this.parent = parent;
    }

    protected boolean isResultOfExpressionUsed(JExpression expr) {
        throw new AssertionError((Object)"Not yet supported");
    }

    public boolean canThrow() {
        return false;
    }

    @Nonnull
    public <T extends Marker> List<T> getSubTreeMarkers(@Nonnull SubTreeMarkersCollector<T> collector) {
        return collector.getSubTreeMarkers(this);
    }

    @Nonnull
    public <T extends Marker> List<T> getSubTreeMarkersOnNextSibling(@Nonnull SubTreeMarkersCollector<T> collector) {
        return collector.getSubTreeMarkersOnNextSibling(this);
    }

    @Nonnull
    public <T extends Marker> List<T> getSubTreeMarkersOnPreviousSibling(@Nonnull SubTreeMarkersCollector<T> collector) {
        return collector.getSubTreeMarkersOnPreviousSibling(this);
    }

    @Nonnull
    public <T extends Marker> List<T> getMarkersOnNodesLeftToPath(@Nonnull SubTreeMarkersCollector<T> collector, @Nonnull JNode subTreeRoot) {
        return collector.getMarkersOnNodesLeftToPath(subTreeRoot, this);
    }

    @Nonnull
    public <T extends Marker> List<T> getMarkersOnNodesRightToPath(@Nonnull SubTreeMarkersCollector<T> collector, @Nonnull JNode subTreeRoot) {
        return collector.getMarkersOnNodesRightToPath(subTreeRoot, this);
    }

    public abstract void checkValidity();

    private static class ParentSetterVisitor
    extends JVisitor {
        final Stack<JNode> nodes = new Stack();

        private ParentSetterVisitor(@Nonnull JNode initialParent) {
            super(false);
            assert (initialParent != null);
            this.nodes.push(initialParent);
        }

        @Override
        public boolean visit(@Nonnull JNode node) {
            assert (!this.nodes.isEmpty());
            JNode newParent = this.nodes.peek();
            this.nodes.push(node);
            if (node.getParent() == newParent) {
                return false;
            }
            node.setParent(newParent);
            return super.visit(node);
        }

        @Override
        public void endVisit(@Nonnull JNode node) {
            this.nodes.pop();
            super.endVisit(node);
        }
    }

    protected static enum Transformation {
        REMOVE,
        REPLACE,
        INSERT_BEFORE,
        INSERT_AFTER;

    }
}

