/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="New array expression")
public class JNewArray
extends JExpression {
    @Nonnull
    private final List<JExpression> dims;
    @Nonnull
    private final List<JExpression> initializers;
    @Nonnull
    private final JArrayType type;

    @Nonnull
    public static JNewArray createWithInits(@Nonnull SourceInfo info, @Nonnull JArrayType type, @Nonnull List<JExpression> initializers) {
        ArrayList<JExpression> dims = new ArrayList<JExpression>();
        dims.add(new JIntLiteral(info, initializers.size()));
        return new JNewArray(info, type, dims, initializers);
    }

    @Nonnull
    public static JNewArray createWithDims(@Nonnull SourceInfo info, @Nonnull JArrayType type, @Nonnull List<JExpression> dims) {
        return new JNewArray(info, type, dims, Collections.emptyList());
    }

    private JNewArray(@Nonnull SourceInfo info, @Nonnull JArrayType type, @Nonnull List<JExpression> dims, @Nonnull List<JExpression> initializers) {
        super(info);
        this.type = type;
        this.dims = dims;
        this.initializers = initializers;
    }

    @Nonnull
    public JArrayType getArrayType() {
        return this.type;
    }

    @Override
    public JArrayType getType() {
        return this.type;
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            if (!this.dims.isEmpty()) {
                visitor.accept(this.dims);
            }
            if (!this.initializers.isEmpty()) {
                visitor.accept(this.initializers);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JExpression dim : this.dims) {
            dim.traverse(schedule);
        }
        for (JExpression initializer : this.initializers) {
            initializer.traverse(schedule);
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JNewArray.transform(this.dims, existingNode, (JExpression)newNode, transformation) && !JNewArray.transform(this.initializers, existingNode, (JExpression)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Nonnull
    public List<JExpression> getDims() {
        return this.dims;
    }

    @Nonnull
    public List<JExpression> getInitializers() {
        return this.initializers;
    }

    public boolean hasConstantInitializer() {
        JType eltType = this.getType().getElementType();
        if (eltType instanceof JPrimitiveType) {
            if (this.initializers.isEmpty()) {
                return false;
            }
            for (JExpression initExpression : this.initializers) {
                if (initExpression instanceof JValueLiteral && initExpression.getType().isSameType(eltType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

