/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="A (name, value) pair. These are used as the contents of an annotation.")
public final class JNameValuePair
extends JNode {
    @Nonnull
    private JMethodIdWide methodId;
    @Nonnull
    private JLiteral value;

    public JNameValuePair(@Nonnull SourceInfo sourceInfo, @Nonnull JMethodIdWide methodId, @Nonnull JLiteral value) {
        super(sourceInfo);
        this.methodId = methodId;
        this.value = value;
    }

    @Nonnull
    public String getName() {
        return this.methodId.getName();
    }

    @Nonnull
    public JMethodIdWide getMethodId() {
        return this.methodId;
    }

    @Nonnull
    public JLiteral getValue() {
        return this.value;
    }

    public void setValue(@Nonnull JLiteral value) {
        this.value = value;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.value);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.value.traverse(schedule);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        if (existingNode == this.value) {
            this.value = (JLiteral)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    public void resolveMethodId(@Nonnull JMethodIdWide methodId) {
        this.methodId = methodId;
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JAnnotation)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }
}

