/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLabeledStatementUnresolved;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Goto statement.")
public class JGoto
extends JStatement {
    @Nonnull
    private JLabeledStatement labeledStmt;

    public JGoto(@Nonnull SourceInfo info, @Nonnull JLabeledStatement labeledStmt) {
        super(info);
        assert (labeledStmt instanceof JLabeledStatementUnresolved || labeledStmt.getBody() instanceof JBlock) : "Goto must target labeled block.";
        this.labeledStmt = labeledStmt;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Nonnull
    public JLabeledStatement getTargetBlock() {
        return this.labeledStmt;
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) {
        if (this.labeledStmt == existingNode) {
            this.labeledStmt = (JLabeledStatement)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    public void setTarget(@Nonnull JLabeledStatement target) {
        assert (target.getBody() instanceof JBlock) : "Goto must target labeled block.";
        this.labeledStmt = target;
    }

    @Override
    public boolean isUnconditionalBranch() {
        return true;
    }
}

