/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.CanBeSetFinal;
import com.android.jack.ir.ast.CanBeStatic;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.HasEnclosingType;
import com.android.jack.ir.ast.HasModifier;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.HasType;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.FieldLoader;
import com.android.jack.load.NopFieldLoader;
import com.android.jack.util.AnnotationUtils;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java field definition")
public class JField
extends JNode
implements HasName,
HasType,
JVisitable,
CanBeStatic,
HasEnclosingType,
CanBeSetFinal,
Annotable,
HasModifier {
    @CheckForNull
    private JFieldInitializer fieldInitializer = null;
    @Nonnull
    private final JFieldId fieldId;
    @Nonnull
    protected final List<JAnnotation> annotations = new ArrayList<JAnnotation>();
    protected int modifier;
    @Nonnull
    private JDefinedClassOrInterface enclosingType;
    @CheckForNull
    private JLiteral initialValue;
    @Nonnull
    private final FieldLoader loader;

    public JField(@Nonnull SourceInfo info, @Nonnull String name, @Nonnull JDefinedClassOrInterface enclosingType, @Nonnull JType type, int modifier) {
        this(info, name, enclosingType, type, modifier, NopFieldLoader.INSTANCE);
    }

    public JField(@Nonnull SourceInfo info, @Nonnull String name, @Nonnull JDefinedClassOrInterface enclosingType, @Nonnull JType type, int modifier, @Nonnull FieldLoader loader) {
        super(info);
        assert (JModifier.isFieldModifier(modifier)) : "Wrong field modifier.";
        assert (JModifier.isValidFieldModifier(modifier));
        this.modifier = modifier;
        this.enclosingType = enclosingType;
        this.fieldId = new JFieldId(name, type, JModifier.isStatic(modifier) ? FieldKind.STATIC : FieldKind.INSTANCE, this);
        this.loader = loader;
    }

    @CheckForNull
    public JFieldInitializer getFieldInitializer() {
        return this.fieldInitializer;
    }

    @Override
    @Nonnull
    public JDefinedClassOrInterface getEnclosingType() {
        return this.enclosingType;
    }

    @CheckForNull
    public JLiteral getInitialValue() {
        return this.initialValue;
    }

    @CheckForNull
    public JValueLiteral getLiteralInitializer() {
        JExpression initializer = this.getInitializer();
        if (initializer instanceof JValueLiteral) {
            return (JValueLiteral)initializer;
        }
        return null;
    }

    public boolean isPublic() {
        return JModifier.isPublic(this.modifier);
    }

    public boolean isPrivate() {
        return JModifier.isPrivate(this.modifier);
    }

    public boolean isProtected() {
        return JModifier.isProtected(this.modifier);
    }

    @Override
    public boolean isStatic() {
        return JModifier.isStatic(this.modifier);
    }

    public boolean isVolatile() {
        return JModifier.isVolatile(this.modifier);
    }

    public boolean isTransient() {
        return JModifier.isTransient(this.modifier);
    }

    public boolean isEnum() {
        return JModifier.isEnum(this.modifier);
    }

    public boolean isCompileTimeConstant() {
        return JModifier.isCompileTimeConstant(this.modifier);
    }

    @Override
    public void setFinal() {
        if (this.isVolatile()) {
            throw new IllegalStateException("Volatile fields cannot be set final");
        }
        this.modifier |= 0x10;
    }

    public void setFieldInitializer(@CheckForNull JFieldInitializer fieldInitializer) {
        this.fieldInitializer = fieldInitializer;
    }

    public void setInitialValue(@CheckForNull JLiteral constant) {
        this.initialValue = constant;
    }

    public void setVolatile() {
        if (this.isFinal()) {
            throw new IllegalStateException("Final fields cannot be set volatile");
        }
        this.modifier |= 0x40;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            if (visitor.needLoading()) {
                this.loader.ensureAnnotations(this);
            }
            visitor.accept(this.annotations);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JAnnotation annotation : this.annotations) {
            annotation.traverse(schedule);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    public void setEnclosingType(@Nonnull JDefinedClassOrInterface enclosingType) {
        this.enclosingType = enclosingType;
    }

    @Override
    public int getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(int modifier) {
        this.modifier = modifier;
    }

    @CheckForNull
    public JLiteral getConstInitializer() {
        JExpression initializer = this.getInitializer();
        if (this.isFinal() && initializer instanceof JLiteral) {
            return (JLiteral)initializer;
        }
        return null;
    }

    @CheckForNull
    public JExpression getInitializer() {
        if (this.fieldInitializer != null) {
            return this.fieldInitializer.getInitializer();
        }
        return null;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.fieldId.getName();
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.fieldId.getType();
    }

    public boolean hasInitializer() {
        return this.fieldInitializer != null;
    }

    @Override
    public boolean isFinal() {
        return JModifier.isFinal(this.modifier);
    }

    public boolean isSynthetic() {
        return JModifier.isSynthetic(this.modifier);
    }

    public void setSynthetic() {
        this.modifier |= 0x1000;
    }

    @Nonnull
    public JFieldId getId() {
        return this.fieldId;
    }

    @Override
    public void addAnnotation(@Nonnull JAnnotation annotation) {
        this.annotations.add(annotation);
    }

    @Nonnull
    public List<JAnnotation> getAnnotations(@Nonnull JAnnotationType annotationType) {
        this.loader.ensureAnnotation(this, annotationType);
        return Jack.getUnmodifiableCollections().getUnmodifiableList(AnnotationUtils.getAnnotation(this.annotations, annotationType));
    }

    @Override
    @Nonnull
    public Collection<JAnnotation> getAnnotations() {
        this.loader.ensureAnnotations(this);
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.annotations);
    }

    @Override
    @Nonnull
    public Set<JAnnotationType> getAnnotationTypes() {
        this.loader.ensureAnnotations(this);
        return Jack.getUnmodifiableCollections().getUnmodifiableSet(AnnotationUtils.getAnnotationTypes(this.annotations));
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JField.transform(this.annotations, existingNode, (JAnnotation)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JDefinedClassOrInterface)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    @Override
    @CheckForNull
    public <T extends Marker> T getMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.getMarker(cls);
    }

    @Override
    @Nonnull
    public Collection<Marker> getAllMarkers() {
        this.loader.ensureMarkers(this);
        return super.getAllMarkers();
    }

    @Override
    public <T extends Marker> boolean containsMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.containsMarker(cls);
    }

    @Override
    public <T extends Marker> T removeMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.removeMarker(cls);
    }

    @Override
    @Nonnull
    public <T extends Marker> T getMarkerOrDefault(@Nonnull T defaultMarker) {
        this.loader.ensureMarker(this, defaultMarker.getClass());
        return super.getMarkerOrDefault(defaultMarker);
    }

    @Override
    @CheckForNull
    public <T extends Marker> T addMarkerIfAbsent(@Nonnull T marker) {
        this.loader.ensureMarker(this, marker.getClass());
        return super.addMarkerIfAbsent(marker);
    }

    @Override
    public void addAllMarkers(@Nonnull Collection<Marker> collection) {
        this.loader.ensureMarkers(this);
        super.addAllMarkers(collection);
    }
}

