/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.ClassOrInterfaceLoader;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JMethodWithReturnLookupException;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java interface type definition")
public class JDefinedInterface
extends JDefinedClassOrInterface
implements JInterface {
    public JDefinedInterface(@Nonnull SourceInfo info, @Nonnull String name, int modifier, @Nonnull JPackage enclosingPackage, @Nonnull ClassOrInterfaceLoader loader) {
        super(info, name, modifier, enclosingPackage, loader);
        assert (JModifier.isInterface(modifier));
        assert (JModifier.isAbstract(modifier));
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            if (visitor.needLoading()) {
                this.loader.ensureFields(this);
                this.loader.ensureMethods(this);
                this.loader.ensureAnnotations(this);
            }
            visitor.accept(this.fields);
            visitor.accept(this.methods);
            visitor.accept(this.annotations);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JField field : this.fields) {
            field.traverse(schedule);
        }
        for (JMethod method : this.methods) {
            method.traverse(schedule);
        }
        for (JAnnotation annotation : this.annotations) {
            annotation.traverse(schedule);
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JDefinedInterface.transform(this.fields, existingNode, (JField)newNode, transformation) && !JDefinedInterface.transform(this.methods, existingNode, (JMethod)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public boolean canBeSafelyUpcast(@Nonnull JReferenceType castTo) {
        return this.isTrivialCast(castTo) || castTo instanceof JInterface && this.implementsInterface((JInterface)castTo);
    }

    @CheckForNull
    public JMethod getSingleAbstractMethod() {
        JClass jlo = Jack.getSession().getLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);
        if (!(jlo instanceof JDefinedClass)) {
            return null;
        }
        JMethod samMethod = null;
        try {
            samMethod = this.getSamMethod(jlo);
        }
        catch (SamNotFoundException samNotFoundException) {
            // empty catch block
        }
        return samMethod;
    }

    @Nonnull
    private JMethod getSamMethod(@Nonnull JClass jlo) throws SamNotFoundException {
        JMethod samMethod = null;
        for (JMethod mth : this.getMethods()) {
            if (!mth.isAbstract()) continue;
            try {
                JMethod jloMth = ((JDefinedClass)jlo).getMethod(mth.getMethodId());
                if (jloMth.isPublic() && !jloMth.isStatic()) {
                    continue;
                }
            }
            catch (JMethodWithReturnLookupException jloMth) {
                // empty catch block
            }
            if (samMethod == null) {
                samMethod = mth;
                continue;
            }
            throw new SamNotFoundException();
        }
        for (JInterface jInterface : this.getImplements()) {
            if (jInterface instanceof JDefinedInterface) {
                JMethod newSamMethod = ((JDefinedInterface)jInterface).getSamMethod(jlo);
                if (samMethod == null) {
                    samMethod = newSamMethod;
                    continue;
                }
                if (newSamMethod == null || this.methodAreEquals(samMethod, newSamMethod)) continue;
                throw new SamNotFoundException();
            }
            throw new SamNotFoundException();
        }
        return samMethod;
    }

    private boolean methodAreEquals(@Nonnull JMethod mth1, @Nonnull JMethod mth2) {
        if (!mth1.getName().equals(mth2.getName())) {
            return false;
        }
        List<JParameter> mth1Params = mth1.getParams();
        List<JParameter> mth2Params = mth2.getParams();
        if (mth1Params.size() != mth2Params.size()) {
            return false;
        }
        Iterator<JParameter> otherParams = mth1Params.iterator();
        for (JParameter param : mth2Params) {
            if (param.getType().isSameType(otherParams.next().getType())) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleAbstractMethodType() {
        return this.getSingleAbstractMethod() != null;
    }

    private static class SamNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SamNotFoundException() {
        }
    }
}

