/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSynchronizedBlock;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java class literal expression")
public class JClassLiteral
extends JLiteral {
    @Nonnull
    private final JClass javaLangClass = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_CLASS);
    @Nonnull
    private final JType refType;

    public JClassLiteral(@Nonnull SourceInfo sourceInfo, @Nonnull JType type) {
        super(sourceInfo);
        assert (type != null);
        assert (this.javaLangClass != null);
        this.refType = type;
    }

    @Nonnull
    public JType getRefType() {
        return this.refType;
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.javaLangClass;
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JExpression || this.parent instanceof JNameValuePair || this.parent instanceof JAnnotationMethod || this.parent instanceof JFieldInitializer || this.parent instanceof JReturnStatement || this.parent instanceof JSynchronizedBlock || this.parent instanceof JLock || this.parent instanceof JUnlock)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }
}

