/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java case statement")
public class JCaseStatement
extends JStatement {
    @CheckForNull
    private JLiteral expr;

    public JCaseStatement(@Nonnull SourceInfo info, @CheckForNull JLiteral expr) {
        super(info);
        this.expr = expr;
    }

    @CheckForNull
    public JLiteral getExpr() {
        return this.expr;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this) && this.expr != null) {
            visitor.accept(this.expr);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        if (this.expr != null) {
            this.expr.traverse(schedule);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        if (existingNode == this.expr) {
            this.expr = (JLiteral)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JSwitchStatement) && !(this.parent instanceof JBlock)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }
}

