/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPhantomClass;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.formatter.UserFriendlyFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Abstraction of Java method call expressions")
public abstract class JAbstractMethodCall
extends JExpression {
    @CheckForNull
    private JExpression instance;
    @Nonnull
    private JClassOrInterface receiverType;
    @Nonnull
    private final List<JExpression> args = new ArrayList<JExpression>();
    @Nonnull
    private JMethodId methodId;

    protected JAbstractMethodCall(@Nonnull SourceInfo info, @CheckForNull JExpression instance, @Nonnull JClassOrInterface receiverType, @Nonnull JMethodId methodId) {
        super(info);
        assert (receiverType != null);
        assert (methodId != null);
        this.instance = instance;
        this.receiverType = receiverType;
        this.methodId = methodId;
    }

    public void addArg(@Nonnull JExpression toAdd) {
        this.args.add(toAdd);
    }

    public void addArgs(@Nonnull List<JExpression> toAdd) {
        this.args.addAll(toAdd);
    }

    public void addArgs(JExpression ... toAdd) {
        this.args.addAll(Arrays.asList(toAdd));
    }

    @Nonnull
    public List<JExpression> getArgs() {
        return this.args;
    }

    @CheckForNull
    public JExpression getInstance() {
        return this.instance;
    }

    @Nonnull
    public JClassOrInterface getReceiverType() {
        return this.receiverType;
    }

    protected void setReceiverType(@Nonnull JClassOrInterface receiverType) {
        this.receiverType = receiverType;
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JAbstractMethodCall.transform(this.args, existingNode, (JExpression)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.instance == existingNode) {
            this.instance = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (this.instance == existingNode) {
            this.instance = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Nonnull
    public JMethodIdWide getMethodIdWide() {
        return this.methodId.getMethodIdWide();
    }

    @Nonnull
    public JMethodId getMethodId() {
        return this.methodId;
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.methodId.getType();
    }

    public void resolveMethodId(@Nonnull JMethodId methodId) {
        this.methodId = methodId;
    }

    protected void visitChildren(JVisitor visitor) {
        if (this.instance != null) {
            visitor.accept(this.instance);
        }
        visitor.accept(this.args);
    }

    protected void visitChildren(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        if (this.instance != null) {
            this.instance.traverse(schedule);
        }
        for (JExpression arg : this.args) {
            arg.traverse(schedule);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Nonnull
    public String getMethodName() {
        return this.methodId.getMethodIdWide().getName();
    }

    public abstract boolean isCallToPolymorphicMethod();

    static boolean isCallToPolymorphicMethod(@Nonnull JClassOrInterface receiverType, @Nonnull JMethodId methodId) {
        UserFriendlyFormatter formatter = UserFriendlyFormatter.getFormatter();
        String calledMethodName = methodId.getMethodIdWide().getName();
        List<JType> paramTypes = methodId.getMethodIdWide().getParamTypes();
        return receiverType != null && formatter.getName(methodId.getType()).equals("java.lang.Object") && JAbstractMethodCall.isSubtypeOfOrMethodHandle(formatter, receiverType) && (calledMethodName.equals("invoke") || calledMethodName.equals("invokeExact")) && paramTypes.size() == 1 && formatter.getName(paramTypes.get(0)).equals("java.lang.Object[]");
    }

    private static boolean isSubtypeOfOrMethodHandle(@Nonnull UserFriendlyFormatter formatter, @Nonnull JClassOrInterface type) {
        if (type instanceof JPhantomClass) {
            return JAbstractMethodCall.isSubtypeOfOrMethodHandle(formatter, (JPhantomClass)type);
        }
        if (type instanceof JDefinedClass) {
            return JAbstractMethodCall.isSubtypeOfOrMethodHandle(formatter, (JDefinedClass)type);
        }
        return false;
    }

    private static boolean isSubtypeOfOrMethodHandle(@Nonnull UserFriendlyFormatter formatter, @Nonnull JPhantomClass type) {
        return formatter.getName(type).equals("java.lang.invoke.MethodHandle");
    }

    private static boolean isSubtypeOfOrMethodHandle(@Nonnull UserFriendlyFormatter formatter, @Nonnull JDefinedClass type) {
        return formatter.getName(type).equals("java.lang.invoke.MethodHandle") || JAbstractMethodCall.isSubtypeOfOrMethodHandle(formatter, type.getSuperClass());
    }
}

