/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.incremental;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.analysis.dependency.file.FileDependencies;
import com.android.jack.analysis.dependency.library.LibraryDependencies;
import com.android.jack.analysis.dependency.type.TypeDependencies;
import com.android.jack.incremental.CommonFilter;
import com.android.jack.incremental.InputFilter;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.Resource;
import com.android.jack.library.InputLibrary;
import com.android.jack.meta.Meta;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.ReaderFile;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@ImplementationName(iface=InputFilter.class, name="no-filter")
public class NoInputFilter
extends CommonFilter
implements InputFilter {
    @Nonnull
    private final Set<String> fileNamesToCompile;
    @Nonnull
    private final List<? extends InputLibrary> importedLibrariesFromCommandLine;
    @Nonnull
    private final List<? extends InputLibrary> librariesOnClasspathFromCommandLine;

    public NoInputFilter(@Nonnull Options options) {
        this.fileNamesToCompile = this.getJavaFileNamesSpecifiedOnCommandLine(options);
        JSession session = Jack.getSession();
        session.setFileDependencies(new FileDependencies());
        session.setTypeDependencies(new TypeDependencies());
        this.importedLibrariesFromCommandLine = this.getImportedLibraries(ThreadConfig.get(Options.IMPORTED_LIBRARIES));
        this.librariesOnClasspathFromCommandLine = this.getClasspathLibraries(ThreadConfig.get(Options.CLASSPATH), ThreadConfig.get(Jack.STRICT_CLASSPATH));
        LibraryDependencies libraryDependencies = session.getLibraryDependencies();
        libraryDependencies.addImportedLibraries(this.importedLibrariesFromCommandLine);
        libraryDependencies.addLibrariesOnClasspath(this.librariesOnClasspathFromCommandLine);
    }

    @Override
    @Nonnull
    public Set<ReaderFile> getFileToCompile() {
        HashSet<ReaderFile> fileToCompile = new HashSet<ReaderFile>();
        for (String fileName : this.fileNamesToCompile) {
            fileToCompile.add((ReaderFile)this.path2ReaderFile.get(fileName));
        }
        return fileToCompile;
    }

    @Override
    @Nonnull
    public List<? extends InputLibrary> getClasspath() {
        return this.librariesOnClasspathFromCommandLine;
    }

    @Override
    @Nonnull
    public List<? extends InputLibrary> getImportedLibraries() {
        return this.importedLibrariesFromCommandLine;
    }

    @Override
    @Nonnull
    public List<? extends Resource> getImportedResources() {
        return this.importStandaloneResources();
    }

    @Override
    @Nonnull
    public List<? extends Meta> getImportedMetas() {
        return this.importStandaloneMetas();
    }
}

