/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.incremental;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.JackIOException;
import com.android.jack.JackUserException;
import com.android.jack.JarTransformationException;
import com.android.jack.LibraryException;
import com.android.jack.Options;
import com.android.jack.config.id.Carnac;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.Resource;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputJackLibraryCodec;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.InvalidLibrary;
import com.android.jack.library.JackLibraryFactory;
import com.android.jack.library.JarLibrary;
import com.android.jack.library.LibraryReadingException;
import com.android.jack.library.NotJackLibraryException;
import com.android.jack.meta.Meta;
import com.android.jack.meta.MetaImporter;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.ReportableException;
import com.android.jack.reporting.Reporter;
import com.android.jack.resource.ResourceImporter;
import com.android.jack.resource.ResourceReadingException;
import com.android.jill.Jill;
import com.android.jill.JillException;
import com.android.jill.utils.FileUtils;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.Files;
import com.android.sched.util.file.InputZipFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.util.file.ReaderFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.file.ZipException;
import com.android.sched.util.location.DirectoryLocation;
import com.android.sched.util.location.FileLocation;
import com.android.sched.vfs.PrefixedFS;
import com.android.sched.vfs.ReadZipFS;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WrongVFSTypeException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@HasKeyId
public abstract class CommonFilter {
    @Nonnull
    protected final Map<String, ReaderFile> path2ReaderFile = new HashMap<String, ReaderFile>();
    @Nonnull
    public static final BooleanPropertyId IMPORTED_JAR_DEBUG_INFO = ((BooleanPropertyId)BooleanPropertyId.create("jack.import.jar.debug-info", "Keep debug info when importing Jars").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class)).addCategory(Carnac.class);
    @Nonnull
    public static final BooleanPropertyId CLASSPATH_JAR_DEBUG_INFO = BooleanPropertyId.create("jack.classpath.jar.debug-info", "Keep debug info when using Jars on classpath").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId CLASSPATH_JAR_TOLERANT = BooleanPropertyId.create("jack.classpath.jar.tolerant", "Tolerate malformed Jars on classpath").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId IMPORTED_JAR_TOLERANT = BooleanPropertyId.create("jack.import.jar.tolerant", "Tolerate import of malformed Jars").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    private static final String[] JACK_DEFAULT_LIB_PATH = new String[]{"jack-default-lib"};
    @Nonnull
    private final boolean importedJarDebugInfo = ThreadConfig.get(IMPORTED_JAR_DEBUG_INFO);
    @Nonnull
    private final boolean classpathJarDebugInfo = ThreadConfig.get(CLASSPATH_JAR_DEBUG_INFO);
    @Nonnull
    private final boolean classpathJarTolerant = ThreadConfig.get(CLASSPATH_JAR_TOLERANT);
    @Nonnull
    private final boolean importedJarTolerant = ThreadConfig.get(IMPORTED_JAR_TOLERANT);

    @Nonnull
    protected Set<String> getJavaFileNamesSpecifiedOnCommandLine(@Nonnull Options options) {
        Config config = options.getConfig();
        String extension = ".java";
        HashSet<String> javaFileNames = new HashSet<String>();
        for (FileOrDirectory file : (List)((Object)config.get(Options.SOURCES))) {
            if (file instanceof Directory) {
                this.fillFiles(((Directory)file).getFile(), ".java", javaFileNames);
                continue;
            }
            if (!file.getPath().endsWith(".java")) continue;
            javaFileNames.add(file.getPath());
            this.path2ReaderFile.put(file.getPath(), (ReaderFile)file);
        }
        return javaFileNames;
    }

    protected void fillFiles(@Nonnull File folder, @Nonnull String fileExt, @Nonnull Set<String> fileNames) {
        File[] fileList = folder.listFiles();
        if (fileList == null) {
            throw new JackUserException(new IOException("Failed to list " + new DirectoryLocation(folder).getDescription()));
        }
        for (File subFile : fileList) {
            if (subFile.isDirectory()) {
                this.fillFiles(subFile, fileExt, fileNames);
                continue;
            }
            if (!subFile.getName().endsWith(fileExt)) continue;
            String path = subFile.getPath();
            try {
                FileLocation location = new FileLocation(subFile);
                AbstractStreamFile.check(subFile, location);
                FileOrDirectory.checkPermissions(subFile, location, 1);
                fileNames.add(path);
                this.path2ReaderFile.put(path, new ReaderFile(subFile.getPath()));
            }
            catch (WrongPermissionException e) {
                throw new JackUserException(e);
            }
            catch (NotFileException e) {
                throw new JackUserException(e);
            }
            catch (NoSuchFileException e) {
                throw new JackUserException(e);
            }
        }
    }

    @Nonnull
    protected List<InputLibrary> getClasspathLibraries(@Nonnull List<InputLibrary> files, boolean strictMode) {
        List<InputLibrary> libraries = ThreadConfig.get(Options.USE_DEFAULT_LIBRARIES) == false ? new ArrayList<InputLibrary>() : this.getDefaultLibraries();
        for (InputLibrary library : files) {
            if (library instanceof InputJackLibrary) {
                libraries.add(library);
                continue;
            }
            if (library instanceof JarLibrary) {
                File libraryFile = new File(library.getPath());
                if (FileUtils.isJarFile(libraryFile)) {
                    try {
                        com.android.jill.Options jillOptions = new com.android.jill.Options();
                        jillOptions.setBinaryFile(libraryFile);
                        jillOptions.setEmitDebugInfo(this.classpathJarDebugInfo);
                        jillOptions.setTolerant(this.classpathJarTolerant);
                        libraries.add(this.convertJarWithJill(jillOptions));
                        continue;
                    }
                    catch (JarTransformationException e) {
                        Jack.getSession().getReporter().report(Reporter.Severity.FATAL, e);
                        throw new JackAbortException(e);
                    }
                }
                this.reportInvalidClasspathLibrary(new NotJackLibraryException(library.getLocation()), strictMode);
                continue;
            }
            if (library instanceof InvalidLibrary) {
                this.reportInvalidClasspathLibrary(((InvalidLibrary)library).getInvalidCauses().get(0), strictMode);
                continue;
            }
            throw new AssertionError();
        }
        return libraries;
    }

    protected List<? extends InputLibrary> getImportedLibraries(@Nonnull List<InputLibrary> files) {
        ArrayList<InputLibrary> libraries = new ArrayList<InputLibrary>();
        for (InputLibrary library : files) {
            if (library instanceof InputJackLibrary) {
                libraries.add(library);
                continue;
            }
            if (library instanceof JarLibrary) {
                File libraryFile = new File(library.getPath());
                if (FileUtils.isJarFile(libraryFile)) {
                    try {
                        com.android.jill.Options jillOptions = new com.android.jill.Options();
                        jillOptions.setBinaryFile(libraryFile);
                        jillOptions.setEmitDebugInfo(this.importedJarDebugInfo);
                        jillOptions.setTolerant(this.importedJarTolerant);
                        libraries.add(this.convertJarWithJill(jillOptions));
                        continue;
                    }
                    catch (JarTransformationException e) {
                        Jack.getSession().getReporter().report(Reporter.Severity.FATAL, e);
                        throw new JackAbortException(e);
                    }
                }
                LibraryReadingException reportable = new LibraryReadingException(new NotJackLibraryException(library.getLocation()));
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
            if (library instanceof InvalidLibrary) {
                LibraryReadingException reportable = new LibraryReadingException(((InvalidLibrary)library).getInvalidCauses().get(0));
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
            throw new AssertionError();
        }
        return libraries;
    }

    private void reportInvalidClasspathLibrary(@Nonnull Throwable cause, boolean strictMode) {
        if (strictMode) {
            LibraryReadingException reportable = new LibraryReadingException(cause);
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
            throw new JackAbortException(reportable);
        }
        Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new ClasspathEntryIgnoredReportable(cause));
    }

    private List<InputLibrary> getDefaultLibraries() {
        URL location = Jack.class.getProtectionDomain().getCodeSource().getLocation();
        JSession session = Jack.getSession();
        if (location != null) {
            ArrayList<InputLibrary> libraries = new ArrayList<InputLibrary>();
            try {
                File jackJar = new File(location.toURI().getPath());
                for (String prefix : JACK_DEFAULT_LIB_PATH) {
                    PrefixedFS jackVfs = new PrefixedFS(new ReadZipFS(new InputZipFile(jackJar.getPath())), new VPath(prefix, '/'), FileOrDirectory.Existence.MUST_EXIST);
                    libraries.add(JackLibraryFactory.getInputLibrary(jackVfs));
                }
                return libraries;
            }
            catch (LibraryException | WrongVFSTypeException e) {
                EmbeddedLibraryLoadingException reportable = new EmbeddedLibraryLoadingException(e);
                session.getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
            catch (URISyntaxException e) {
                throw new AssertionError();
            }
            catch (CannotCreateFileException e) {
                throw new AssertionError();
            }
            catch (WrongPermissionException e) {
                EmbeddedLibraryLoadingException reportable = new EmbeddedLibraryLoadingException(e);
                session.getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
            catch (NoSuchFileException e) {
                EmbeddedLibraryLoadingException reportable = new EmbeddedLibraryLoadingException(e);
                session.getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
            catch (NotFileOrDirectoryException e) {
                EmbeddedLibraryLoadingException reportable = new EmbeddedLibraryLoadingException(e);
                session.getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
            catch (ZipException e) {
                EmbeddedLibraryLoadingException reportable = new EmbeddedLibraryLoadingException(e);
                session.getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
        }
        EmbeddedLibraryLoadingException e = new EmbeddedLibraryLoadingException(new FailedToLocateJackJarException());
        session.getReporter().report(Reporter.Severity.FATAL, e);
        throw new JackAbortException(e);
    }

    @Nonnull
    private InputJackLibrary convertJarWithJill(@Nonnull com.android.jill.Options jillOptions) throws JarTransformationException {
        try {
            final File tempFile = Files.createTempFile("jill-", ".jack");
            Runnable tempFileDeleter = new Runnable(){

                @Override
                public void run() {
                    boolean deleted = tempFile.delete();
                    if (!deleted) {
                        throw new JackIOException("Failed to delete temporary file " + tempFile.getPath());
                    }
                }
            };
            Jack.getSession().getHooks().addHook(tempFileDeleter);
            jillOptions.setOutput(tempFile);
            Jill.process(jillOptions);
            InputJackLibraryCodec codec = new InputJackLibraryCodec();
            CodecContext context = new CodecContext();
            InputJackLibrary inputLib = codec.checkString(context, tempFile.getPath());
            if (inputLib == null) {
                inputLib = codec.parseString(context, tempFile.getPath());
            }
            return inputLib;
        }
        catch (ParsingException e) {
            throw new JarTransformationException(e.getCause());
        }
        catch (CannotCreateFileException e) {
            throw new JarTransformationException(e);
        }
        catch (CannotChangePermissionException e) {
            throw new JarTransformationException(e);
        }
        catch (JillException e) {
            throw new JarTransformationException(e);
        }
    }

    @Nonnull
    protected List<Resource> importStandaloneResources() {
        List<Resource> resources;
        JSession session = Jack.getSession();
        try {
            resources = new ResourceImporter((List)((Object)ThreadConfig.get(ResourceImporter.IMPORTED_RESOURCES))).getImports();
        }
        catch (ResourceReadingException e) {
            session.getReporter().report(Reporter.Severity.FATAL, e);
            throw new JackAbortException(e);
        }
        return resources;
    }

    @Nonnull
    protected List<Meta> importStandaloneMetas() {
        return new MetaImporter((List)((Object)ThreadConfig.get(MetaImporter.IMPORTED_META))).getImports();
    }

    private static final class ClasspathEntryIgnoredReportable
    implements Reportable {
        @Nonnull
        private final Throwable cause;

        private ClasspathEntryIgnoredReportable(@Nonnull Throwable cause) {
            this.cause = cause;
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Bad classpath entry ignored: " + this.cause.getMessage();
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.WARNING;
        }
    }

    private static final class EmbeddedLibraryLoadingException
    extends ReportableException {
        private static final long serialVersionUID = 1L;

        private EmbeddedLibraryLoadingException(@Nonnull Exception cause) {
            super(cause);
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Error while loading embedded libraries. Try specifying jack classpath: " + this.getCause().getMessage();
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }
    }

    private static final class FailedToLocateJackJarException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private FailedToLocateJackJarException() {
        }

        @Override
        public String getMessage() {
            return "Failed to locate jack jar file";
        }
    }
}

