/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.frontend.java;

import com.android.jack.JackEventType;
import com.android.jack.JackUserException;
import com.android.jack.Options;
import com.android.jack.eclipse.jdt.core.compiler.CompilationProgress;
import com.android.jack.eclipse.jdt.internal.compiler.CompilationResult;
import com.android.jack.eclipse.jdt.internal.compiler.ICompilerRequestor;
import com.android.jack.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import com.android.jack.eclipse.jdt.internal.compiler.IProblemFactory;
import com.android.jack.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.android.jack.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import com.android.jack.eclipse.jdt.internal.compiler.env.AccessRestriction;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryType;
import com.android.jack.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import com.android.jack.eclipse.jdt.internal.compiler.env.INameEnvironment;
import com.android.jack.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import com.android.jack.frontend.java.JackBatchCompiler;
import com.android.jack.frontend.java.JavaParser;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.impl.EcjSourceTypeLoader;
import com.android.jack.ir.impl.JackIrBuilder;
import com.android.jack.ir.impl.ReferenceMapper;
import com.android.jack.ir.impl.SourceCompilationException;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

class JAstBuilder
extends JavaParser {
    @Nonnull
    private final Config config = ThreadConfig.getConfig();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final JSession session;
    @Nonnull
    private JackIrBuilder astBuilder;
    private boolean hasErrors = false;
    private boolean resetJack = false;

    public JAstBuilder(@Nonnull INameEnvironment environment, @Nonnull IErrorHandlingPolicy policy, @Nonnull CompilerOptions options, @Nonnull ICompilerRequestor requestor, @Nonnull IProblemFactory problemFactory, @CheckForNull PrintWriter out, @CheckForNull CompilationProgress progress, @Nonnull JSession session) {
        super(environment, policy, options, requestor, problemFactory, out, progress);
        this.session = session;
        this.astBuilder = new JackIrBuilder(this.lookupEnvironment, session);
    }

    @Nonnull
    private JPackage getOrCreatePackage(@Nonnull char[][] compoundName, int compoundNameLength) {
        assert (compoundNameLength <= compoundName.length && compoundNameLength >= 0);
        JPackage currentPackage = this.session.getTopLevelPackage();
        for (int i = 0; i < compoundNameLength; ++i) {
            String name = String.valueOf(compoundName[i]);
            currentPackage = currentPackage.getOrCreateSubPackage(name);
            currentPackage.setOnPath();
        }
        return currentPackage;
    }

    @Override
    public void process(CompilationUnitDeclaration unit, int i) {
        try (Event jastEvent = this.tracer.open(JackEventType.J_AST_BUILDER);){
            List<JDefinedClassOrInterface> types;
            super.process(unit, i);
            if (this.hasErrors || unit.hasErrors() || unit.compilationResult().hasErrors()) {
                this.hasErrors = true;
                return;
            }
            List<JDefinedClassOrInterface> loadedLocalTypes = this.loadLocalClasses(unit);
            try (Event jackIrBuilderEvent = this.tracer.open(JackEventType.JACK_IR_BUILDER);){
                types = this.astBuilder.process(unit);
            }
            catch (SourceCompilationException e) {
                if (jastEvent != null) {
                    if (var4_5 != null) {
                        try {
                            jastEvent.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        jastEvent.close();
                    }
                }
                return;
            }
            for (JDefinedClassOrInterface type : loadedLocalTypes) {
                if (types.contains(type)) continue;
                type.getEnclosingPackage().remove(type);
            }
            for (JDefinedClassOrInterface type : types) {
                this.session.addTypeToEmit(type);
            }
            if (this.config.get(Options.EMIT_CLASS_FILES).booleanValue()) {
                unit.generateCode();
            }
        }
        catch (IllegalArgumentException e) {
            AssertionError error = new AssertionError();
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    @Override
    protected synchronized void addCompilationUnit(@CheckForNull ICompilationUnit sourceUnit, @CheckForNull CompilationUnitDeclaration parsedUnit) {
        super.addCompilationUnit(sourceUnit, parsedUnit);
        assert (parsedUnit != null);
        if (parsedUnit.types != null) {
            JPackage enclosingPackage;
            if (parsedUnit.currentPackage != null) {
                char[][] packageNames = parsedUnit.currentPackage.tokens;
                enclosingPackage = this.getOrCreatePackage(packageNames, packageNames.length);
            } else {
                enclosingPackage = this.session.getTopLevelPackage();
            }
            ReferenceMapper refMap = this.astBuilder.getTypeMap();
            for (TypeDeclaration typeDeclaration : parsedUnit.types) {
                this.createTypes(enclosingPackage, refMap, typeDeclaration);
            }
        }
    }

    @Nonnull
    private List<JDefinedClassOrInterface> loadLocalClasses(@Nonnull CompilationUnitDeclaration unit) {
        ArrayList<JDefinedClassOrInterface> types = new ArrayList<JDefinedClassOrInterface>();
        if (unit.localTypes != null) {
            JPackage enclosingPackage;
            if (unit.currentPackage != null) {
                char[][] packageNames = unit.currentPackage.tokens;
                enclosingPackage = this.getOrCreatePackage(packageNames, packageNames.length);
            } else {
                enclosingPackage = this.session.getTopLevelPackage();
            }
            ReferenceMapper refMap = this.astBuilder.getTypeMap();
            for (LocalTypeBinding binding : unit.localTypes) {
                if (binding == null || binding.constantPoolName() == null) continue;
                types.add(EcjSourceTypeLoader.createType(refMap, enclosingPackage, binding, null, new FileLocation(new String(unit.getFileName()))));
            }
        }
        return types;
    }

    private void createTypes(@Nonnull JPackage enclosingPackage, @Nonnull ReferenceMapper refMap, @Nonnull TypeDeclaration typeDeclaration) {
        if (this.hasErrors || JackIrBuilder.hasError(typeDeclaration)) {
            this.hasErrors = true;
            return;
        }
        EcjSourceTypeLoader.createType(refMap, enclosingPackage, typeDeclaration.binding, typeDeclaration, new FileLocation(new String(typeDeclaration.compilationResult.fileName)));
        if (typeDeclaration.memberTypes != null) {
            for (TypeDeclaration memberType : typeDeclaration.memberTypes) {
                this.createTypes(enclosingPackage, refMap, memberType);
            }
        }
    }

    @Override
    protected void handleInternalException(@Nonnull Throwable internalException, @CheckForNull CompilationUnitDeclaration unit, @CheckForNull CompilationResult result) {
        if (internalException instanceof IllegalArgumentException) {
            throw new JackBatchCompiler.TransportJUEAroundEcjError(new JackUserException(internalException));
        }
        if (internalException instanceof JackUserException) {
            throw new JackBatchCompiler.TransportJUEAroundEcjError((JackUserException)internalException);
        }
        if (internalException instanceof RuntimeException) {
            throw (RuntimeException)internalException;
        }
        if (internalException instanceof Error) {
            throw (Error)internalException;
        }
        throw new JNodeInternalError(internalException);
    }

    @Override
    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        BinaryTypeBinding btb = this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
        if (btb.id == 69 || btb.id == 70) {
            btb.id = Integer.MAX_VALUE;
        }
    }

    @Override
    protected void backupAptProblems() {
        this.resetJack = true;
        super.backupAptProblems();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.resetJack) {
            this.session.reset();
            this.astBuilder = new JackIrBuilder(this.lookupEnvironment, this.session);
            this.resetJack = false;
        }
    }

    public void finishCompilation() {
        this.astBuilder.finishCompilation();
    }
}

