/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.frontend.java;

import com.android.jack.eclipse.jdt.core.compiler.CategorizedProblem;
import com.android.jack.eclipse.jdt.internal.compiler.batch.Main;
import com.android.jack.frontend.java.EcjProblem;
import com.android.jack.frontend.java.JackBatchCompiler;
import com.android.jack.reporting.Reporter;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class EcjLogger
extends Main.Logger {
    @Nonnull
    private final JackBatchCompiler jackBatchCompiler;
    @CheckForNull
    private Reporter reporter;

    public EcjLogger(@Nonnull Main main, @Nonnull PrintWriter out, @Nonnull PrintWriter err, @Nonnull JackBatchCompiler jackBatchCompiler) {
        super(main, out, err);
        this.jackBatchCompiler = jackBatchCompiler;
    }

    @Override
    public int logProblems(@Nonnull CategorizedProblem[] problems, @Nonnull char[] unitSource, @Nonnull Main currentMain) {
        return this.report(problems, currentMain);
    }

    private int report(@Nonnull CategorizedProblem[] problems, @Nonnull Main currentMain) {
        if (this.reporter == null) {
            this.reporter = this.jackBatchCompiler.getReporter();
        }
        int numErrors = 0;
        for (CategorizedProblem problem : problems) {
            if (problem == null) continue;
            this.reporter.report(Reporter.Severity.NON_FATAL, new EcjProblem(problem));
            ++currentMain.globalProblemsCount;
            if (problem.isError()) {
                ++currentMain.globalErrorsCount;
                ++numErrors;
                continue;
            }
            if (!problem.isWarning()) continue;
            ++currentMain.globalWarningsCount;
        }
        return numErrors;
    }

    @Override
    public void loggingExtraProblems(@Nonnull Main currentMain) {
        List<CategorizedProblem> extras = this.jackBatchCompiler.getExtraProblems();
        if (extras != null) {
            this.report(extras.toArray(new CategorizedProblem[extras.size()]), currentMain);
        }
    }
}

