/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.BuiltIn;
import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.Expression;
import com.android.jack.freemarker.core.InvalidReferenceException;
import com.android.jack.freemarker.core.MessageUtil;
import com.android.jack.freemarker.core.ParentheticalExpression;
import com.android.jack.freemarker.template.TemplateBooleanModel;
import com.android.jack.freemarker.template.TemplateException;
import com.android.jack.freemarker.template.TemplateMethodModelEx;
import com.android.jack.freemarker.template.TemplateModel;
import com.android.jack.freemarker.template.TemplateModelException;
import java.util.List;

class ExistenceBuiltins {
    private ExistenceBuiltins() {
    }

    static class if_existsBI
    extends ExistenceBuiltIn {
        if_existsBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.evalMaybeNonexistentTarget(env);
            return model == null ? TemplateModel.NOTHING : model;
        }
    }

    static class has_contentBI
    extends ExistenceBuiltIn {
        has_contentBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            return Expression.isEmpty(this.evalMaybeNonexistentTarget(env)) ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
        }

        boolean evalToBoolean(Environment env) throws TemplateException {
            return this._eval(env) == TemplateBooleanModel.TRUE;
        }
    }

    static class existsBI
    extends ExistenceBuiltIn {
        existsBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            return this.evalMaybeNonexistentTarget(env) == null ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
        }

        boolean evalToBoolean(Environment env) throws TemplateException {
            return this._eval(env) == TemplateBooleanModel.TRUE;
        }
    }

    static class defaultBI
    extends ExistenceBuiltIn {
        private static final TemplateMethodModelEx FIRST_NON_NULL_METHOD = new TemplateMethodModelEx(){

            public Object exec(List args) throws TemplateModelException {
                int argCnt = args.size();
                if (argCnt == 0) {
                    throw MessageUtil.newArgCntError("?default", argCnt, 1, Integer.MAX_VALUE);
                }
                for (int i = 0; i < argCnt; ++i) {
                    TemplateModel result = (TemplateModel)args.get(i);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        };

        defaultBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.evalMaybeNonexistentTarget(env);
            return model == null ? FIRST_NON_NULL_METHOD : new ConstantMethod(model);
        }

        private static class ConstantMethod
        implements TemplateMethodModelEx {
            private final TemplateModel constant;

            ConstantMethod(TemplateModel constant) {
                this.constant = constant;
            }

            public Object exec(List args) {
                return this.constant;
            }
        }
    }

    private static abstract class ExistenceBuiltIn
    extends BuiltIn {
        private ExistenceBuiltIn() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TemplateModel evalMaybeNonexistentTarget(Environment env) throws TemplateException {
            TemplateModel tm;
            if (this.target instanceof ParentheticalExpression) {
                boolean lastFIRE = env.setFastInvalidReferenceExceptions(true);
                try {
                    tm = this.target.eval(env);
                }
                catch (InvalidReferenceException ire) {
                    tm = null;
                }
                finally {
                    env.setFastInvalidReferenceExceptions(lastFIRE);
                }
            } else {
                tm = this.target.eval(env);
            }
            return tm;
        }
    }
}

