/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.eclipse.jdt.internal.compiler.lookup;

import com.android.jack.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.Scope;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.Substitution;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class InferenceSubstitution
extends Scope.Substitutor
implements Substitution {
    private LookupEnvironment environment;
    private InferenceVariable[] variables;
    private InvocationSite site;

    public InferenceSubstitution(LookupEnvironment environment, InferenceVariable[] variables, InvocationSite site) {
        this.environment = environment;
        this.variables = variables;
        this.site = site;
    }

    public InferenceSubstitution(InferenceContext18 context) {
        this(context.environment, context.inferenceVariables, context.currentInvocation);
    }

    @Override
    public TypeBinding substitute(Substitution substitution, TypeBinding originalType) {
        int i = 0;
        while (i < this.variables.length) {
            InferenceVariable variable = this.variables[i];
            if (InferenceContext18.isSameSite(this.site, variable.site) && TypeBinding.equalsEquals(this.getP(i), originalType)) {
                if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled && originalType.hasNullTypeAnnotations()) {
                    return this.environment.createAnnotatedType(variable.withoutToplevelNullAnnotation(), originalType.getTypeAnnotations());
                }
                return variable;
            }
            ++i;
        }
        return super.substitute(substitution, originalType);
    }

    protected TypeBinding getP(int i) {
        return this.variables[i].typeParameter;
    }

    @Override
    public TypeBinding substitute(TypeVariableBinding typeVariable) {
        ReferenceBinding superclass = typeVariable.superclass;
        ReferenceBinding[] superInterfaces = typeVariable.superInterfaces;
        boolean hasSubstituted = false;
        int i = 0;
        while (i < this.variables.length) {
            InferenceVariable variable = this.variables[i];
            TypeBinding pi = this.getP(i);
            if (TypeBinding.equalsEquals(pi, typeVariable)) {
                return variable;
            }
            if (TypeBinding.equalsEquals(pi, superclass)) {
                superclass = variable;
                hasSubstituted = true;
            } else if (superInterfaces != null) {
                int ifcLen = superInterfaces.length;
                int j = 0;
                while (j < ifcLen) {
                    if (TypeBinding.equalsEquals(pi, superInterfaces[j])) {
                        if (superInterfaces == typeVariable.superInterfaces) {
                            ReferenceBinding[] referenceBindingArray = superInterfaces;
                            superInterfaces = new ReferenceBinding[ifcLen];
                            System.arraycopy(referenceBindingArray, 0, superInterfaces, 0, ifcLen);
                        }
                        superInterfaces[j] = variable;
                        hasSubstituted = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (hasSubstituted) {
            typeVariable = new TypeVariableBinding(typeVariable.sourceName, typeVariable.declaringElement, typeVariable.rank, this.environment);
            typeVariable.superclass = superclass;
            typeVariable.superInterfaces = superInterfaces;
            TypeBinding typeBinding = typeVariable.firstBound = superclass != null ? superclass : superInterfaces[0];
            if (typeVariable.firstBound.hasNullTypeAnnotations()) {
                typeVariable.tagBits |= 0x100000L;
            }
        }
        return typeVariable;
    }

    @Override
    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public boolean isRawSubstitution() {
        return false;
    }
}

