/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ecj.loader.jast;

import com.android.jack.ecj.loader.jast.JAstBinaryType;
import com.android.jack.ecj.loader.jast.LoaderUtils;
import com.android.jack.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import com.android.jack.eclipse.jdt.internal.compiler.batch.FileSystem;
import com.android.jack.eclipse.jdt.internal.compiler.env.AccessRestriction;
import com.android.jack.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import com.android.jack.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JType;
import com.android.jack.lookup.JLookupException;
import com.android.jack.lookup.JNodeLookup;
import java.io.File;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JAstClasspath
extends ClasspathLocation {
    @Nonnull
    protected final JNodeLookup lookup;
    @Nonnull
    private final String virtualFilePath;

    public JAstClasspath(@Nonnull String virtualFilePath, @Nonnull JNodeLookup lookup, @CheckForNull AccessRuleSet accessRuleSet) {
        super(accessRuleSet, "none");
        this.lookup = lookup;
        this.virtualFilePath = virtualFilePath;
    }

    @Override
    @CheckForNull
    public char[][][] findTypeNames(@CheckForNull String qualifiedPackageName) {
        throw new AssertionError((Object)"No yet implemented");
    }

    @Override
    @CheckForNull
    public NameEnvironmentAnswer findClass(@CheckForNull char[] typeName, @CheckForNull String qualifiedPackageName, @CheckForNull String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName, false);
    }

    @Override
    @CheckForNull
    public NameEnvironmentAnswer findClass(@CheckForNull char[] typeName, @CheckForNull String qualifiedPackageName, @CheckForNull String qualifiedBinaryFileName, boolean asBinaryOnly) {
        assert (typeName != null);
        assert (qualifiedBinaryFileName != null);
        assert (qualifiedPackageName != null);
        String simpleName = new String(typeName);
        String searchedDescriptor = qualifiedPackageName.isEmpty() ? "L" + simpleName + ";" : "L" + qualifiedPackageName.replace(File.separatorChar, '/') + '/' + simpleName + ";";
        try {
            JType type = this.lookup.getType(searchedDescriptor);
            if (type instanceof JDefinedClassOrInterface) {
                assert (!(type instanceof JDefinedClass) || ((JDefinedClass)type).getEnclosingMethod() == null);
                JDefinedClassOrInterface declaredType = (JDefinedClassOrInterface)type;
                AccessRestriction restriction = this.fetchAccessRestriction(LoaderUtils.getQualifiedNameFormatter().getName(declaredType) + ".CLASS");
                return new NameEnvironmentAnswer(new JAstBinaryType(declaredType, this), restriction);
            }
            return null;
        }
        catch (JLookupException e) {
            return null;
        }
    }

    @Override
    public boolean isPackage(@CheckForNull String qualifiedPackageName) {
        assert (qualifiedPackageName != null);
        return this.lookup.isPackageOnPath(qualifiedPackageName.replace(File.separatorChar, '/'));
    }

    @Override
    @CheckForNull
    public List<? extends FileSystem.Classpath> fetchLinkedJars(@CheckForNull FileSystem.ClasspathSectionProblemReporter problemReporter) {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    @Nonnull
    public char[] normalizedPath() {
        String path = this.virtualFilePath.replace(File.separatorChar, '/');
        if (path.indexOf(47) < path.indexOf(46)) {
            path = path.substring(0, path.indexOf(46));
        }
        return path.toCharArray();
    }

    @CheckForNull
    JAstBinaryType findType(@Nonnull JDefinedClassOrInterface type) {
        return new JAstBinaryType(type, this);
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.virtualFilePath;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean hasAnnotationFileFor(String qualifiedTypeName) {
        return false;
    }
}

