/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.ssa;

import com.android.jack.dx.rop.code.RegisterSpec;
import com.android.jack.dx.rop.code.RegisterSpecSet;
import com.android.jack.dx.ssa.SsaBasicBlock;
import com.android.jack.dx.ssa.SsaInsn;
import com.android.jack.dx.ssa.SsaMethod;
import com.android.jack.dx.util.MutabilityControl;
import java.util.ArrayList;
import java.util.HashMap;

public class LocalVariableInfo
extends MutabilityControl {
    private final int regCount;
    private final RegisterSpecSet emptySet;
    private final RegisterSpecSet[] blockStarts;
    private final HashMap<SsaInsn, RegisterSpec> insnAssignments;

    public LocalVariableInfo(SsaMethod method) {
        assert (method != null);
        ArrayList<SsaBasicBlock> blocks = method.getBlocks();
        this.regCount = method.getRegCount();
        this.emptySet = new RegisterSpecSet(this.regCount);
        this.blockStarts = new RegisterSpecSet[blocks.size()];
        this.insnAssignments = new HashMap();
        this.emptySet.setImmutable();
    }

    public void setStarts(int index, RegisterSpecSet specs) {
        assert (specs != null);
        this.throwIfImmutable();
        try {
            this.blockStarts[index] = specs;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("bogus index");
        }
    }

    public boolean mergeStarts(int index, RegisterSpecSet specs) {
        RegisterSpecSet start = this.getStarts0(index);
        if (start == null) {
            this.setStarts(index, specs);
            return true;
        }
        RegisterSpecSet newStart = start.mutableCopy();
        newStart.intersect(specs, true);
        if (start.equals(newStart)) {
            return false;
        }
        newStart.setImmutable();
        this.setStarts(index, newStart);
        return true;
    }

    public RegisterSpecSet getStarts(int index) {
        RegisterSpecSet result = this.getStarts0(index);
        return result != null ? result : this.emptySet;
    }

    public RegisterSpecSet getStarts(SsaBasicBlock block) {
        return this.getStarts(block.getIndex());
    }

    public RegisterSpecSet mutableCopyOfStarts(int index) {
        RegisterSpecSet result = this.getStarts0(index);
        return result != null ? result.mutableCopy() : new RegisterSpecSet(this.regCount);
    }

    public void addAssignment(SsaInsn insn, RegisterSpec spec) {
        assert (insn != null);
        assert (spec != null);
        this.throwIfImmutable();
        this.insnAssignments.put(insn, spec);
    }

    public RegisterSpec getAssignment(SsaInsn insn) {
        return this.insnAssignments.get(insn);
    }

    public int getAssignmentCount() {
        return this.insnAssignments.size();
    }

    public void debugDump() {
        for (int index = 0; index < this.blockStarts.length; ++index) {
            if (this.blockStarts[index] == null) continue;
            Integer indexInteger = index;
            if (this.blockStarts[index] == this.emptySet) {
                System.out.printf("%04x: empty set\n", indexInteger);
                continue;
            }
            System.out.printf("%04x: %s\n", indexInteger, this.blockStarts[index]);
        }
    }

    private RegisterSpecSet getStarts0(int index) {
        try {
            return this.blockStarts[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("bogus index");
        }
    }
}

