/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.cst;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.IndexedItem;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.rop.cst.CstCallSiteRef;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstMethodHandleRef;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.type.Type;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CstIndexMap {
    @Nonnull
    private final CstString[] strings;
    @Nonnull
    private final Type[] types;
    @Nonnull
    private final CstMethodRef[] methods;
    @Nonnull
    private final CstFieldRef[] fields;
    @Nonnull
    private final CstPrototypeRef[] prototypes;
    @Nonnull
    private final CstMethodHandleRef[] methodHandles;
    private final CstCallSiteRef[] callSites;

    public CstIndexMap(@Nonnull DexBuffer dexBuffer) {
        this.strings = new CstString[dexBuffer.strings().size()];
        this.types = new Type[dexBuffer.typeNames().size()];
        this.methods = new CstMethodRef[dexBuffer.methodIds().size()];
        this.fields = new CstFieldRef[dexBuffer.fieldIds().size()];
        this.prototypes = new CstPrototypeRef[dexBuffer.protoIds().size()];
        this.methodHandles = new CstMethodHandleRef[dexBuffer.methodHandleIds().size()];
        this.callSites = new CstCallSiteRef[dexBuffer.callSiteIds().size()];
    }

    public void addStringMapping(@Nonnegative int index, @Nonnull CstString cstString) {
        assert (this.strings[index] == null || this.strings[index].compareTo(cstString) == 0);
        if (this.strings[index] == null) {
            this.strings[index] = cstString;
        }
    }

    public void addTypeMapping(@Nonnegative int index, @Nonnull Type type) {
        assert (this.types[index] == null || this.types[index].compareTo(type) == 0);
        if (this.types[index] == null) {
            this.types[index] = type;
        }
    }

    public void addMethodMapping(@Nonnegative int index, @Nonnull CstMethodRef methodRef) {
        assert (this.methods[index] == null || this.methods[index].compareTo(methodRef) == 0);
        if (this.methods[index] == null) {
            this.methods[index] = methodRef;
        }
    }

    public void addPrototypeMapping(@Nonnegative int index, @Nonnull CstPrototypeRef prototypeRef) {
        assert (this.prototypes[index] == null || this.prototypes[index].compareTo(prototypeRef) == 0);
        if (this.prototypes[index] == null) {
            this.prototypes[index] = prototypeRef;
        }
    }

    public void addFieldMapping(@Nonnegative int index, @Nonnull CstFieldRef fieldRef) {
        assert (this.fields[index] == null || this.fields[index].compareTo(fieldRef) == 0);
        if (this.fields[index] == null) {
            this.fields[index] = fieldRef;
        }
    }

    public void addMethodHandleMapping(@Nonnegative int index, @Nonnull CstMethodHandleRef methodHandleRef) {
        assert (this.methodHandles[index] == null || this.methodHandles[index].compareTo(methodHandleRef) == 0);
        if (this.methodHandles[index] == null) {
            this.methodHandles[index] = methodHandleRef;
        }
    }

    public void addCallSiteMapping(@Nonnegative int index, @Nonnull CstCallSiteRef callSiteRef) {
        assert (this.callSites[index] == null || this.callSites[index].compareTo(callSiteRef) == 0);
        if (this.callSites[index] == null) {
            this.callSites[index] = callSiteRef;
        }
    }

    public int getRemappedCstStringIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.strings[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstTypeIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.types[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstBaseMethodRefIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.methods[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstFieldRefIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.fields[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstPrototypeRefIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.prototypes[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstCallSiteRefIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.callSites[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    @Nonnull
    public CstMethodRef getCstMethodRef(@Nonnegative int index) {
        CstMethodRef cstMethodRef = this.methods[index];
        assert (cstMethodRef != null);
        return cstMethodRef;
    }

    @Nonnull
    public CstFieldRef getCstFieldRef(@Nonnegative int index) {
        CstFieldRef cstFieldRef = this.fields[index];
        assert (cstFieldRef != null);
        return cstFieldRef;
    }

    @Nonnull
    public CstString getCstString(@Nonnegative int index) {
        CstString cstString = this.strings[index];
        assert (cstString != null);
        return cstString;
    }

    @Nonnull
    public Type getType(@Nonnegative int index) {
        Type cstType = this.types[index];
        assert (cstType != null);
        return cstType;
    }

    @Nonnull
    public CstPrototypeRef getCstPrototype(@Nonnegative int index) {
        CstPrototypeRef cstPrototypeRef = this.prototypes[index];
        assert (cstPrototypeRef != null);
        return cstPrototypeRef;
    }

    @Nonnull
    public CstMethodHandleRef getCstMethodHandle(@Nonnegative int index) {
        CstMethodHandleRef cstMethodHandleRef = this.methodHandles[index];
        assert (cstMethodHandleRef != null);
        return cstMethodHandleRef;
    }

    @Nonnull
    public CstCallSiteRef[] getCstCallSitesType() {
        return this.callSites;
    }
}

